/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.task.RegisterVMSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VmVirtualDisk;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualMachineRelocateSpecDiskLocator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Sets;

public class MigrateResourceOnlySubTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(MigrateResourceOnlySubTask.class);
    private static final Set<Integer> RDM_DISK_TYPE = Sets.newHashSet((Object[])new Integer[]{DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue(), DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue()});
    private String targetDatastoreMoId;
    private VsphereVirtualMachine targetVm;
    private VsphereVirtualMachine oldVm;

    public MigrateResourceOnlySubTask() {
    }

    public MigrateResourceOnlySubTask(VsphereVirtualMachine vm, VsphereVirtualMachine oldVm, String targetDatastoreMoId) {
        this.targetVm = vm;
        this.oldVm = oldVm;
        this.targetDatastoreMoId = targetDatastoreMoId;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        VerifyUtil.checkObjs((Object[])new Object[]{this.targetVm});
        logger.info((Object)"do migration with vm: vmName=%s, vmMoId=%s", new Object[]{this.targetVm.getName(), this.targetVm.getVmMoId()});
        boolean result = this.doMigration(context);
        if (!result) {
            logger.error((Object)"migrate vm failed.");
            return this.failure(new LegoCheckedException(1073948947L));
        }
        return this.success();
    }

    private boolean doMigration(RecoveryProcessorContext context) {
        this.checkMigrationParam();
        this.updateProcessNameParams(new String[]{this.targetVm.getName()});
        Set virtualDisks = this.targetVm.getVirtualDisk();
        VerifyUtil.checkObject((Object)virtualDisks);
        logger.info((Object)"vm(%s) disk size: %s", new Object[]{this.targetVm.getName(), virtualDisks.size()});
        String vCenterUuid = context.getProtectGroup().getPoProviderSN();
        ArrayList configuredDiskList = new ArrayList(virtualDisks);
        configuredDiskList.stream().findAny().orElseThrow(() -> new LegoCheckedException(2117645L));
        DataStoreAction vmAction = new DataStoreAction();
        List<VirtualMachineRelocateSpecDiskLocator> diskLocators = configuredDiskList.stream().filter(disk -> !RDM_DISK_TYPE.contains(disk.getDiskType())).map(this::convertToDiskSpec).collect(Collectors.toList());
        boolean migrationTask = vmAction.migrateVmByStorage(vCenterUuid, this.targetVm.getVmMoId(), this.targetDatastoreMoId, diskLocators);
        if (!migrationTask) {
            logger.error((Object)"migration failed");
            return this.failure();
        }
        return this.success();
    }

    private void checkMigrationParam() {
        if (VerifyUtil.isEmpty((Object)this.targetVm) || VerifyUtil.isEmpty((Object)this.oldVm)) {
            logger.error((Object)"target vm is empty.");
            this.updateProcessNameParams(new String[]{"--"});
            throw new LegoCheckedException(2117645L);
        }
    }

    private VirtualMachineRelocateSpecDiskLocator convertToDiskSpec(VmVirtualDisk vmDisk) {
        logger.info((Object)"convert disk to spec: %s", new Object[]{JSONObject.fromObject((Object)vmDisk).toString()});
        VirtualMachineRelocateSpecDiskLocator vmDiskSpec = new VirtualMachineRelocateSpecDiskLocator();
        vmDiskSpec.setDiskId(vmDisk.getDeviceKey().intValue());
        String datastoreUuId = vmDisk.getDatastoreId();
        RecoveryProcessorContext contextRef = this.getContextRef();
        String datastoreMoId = this.findDatastore(contextRef, datastoreUuId);
        VerifyUtil.checkObjs((Object[])new Object[]{datastoreMoId});
        ManagedObjectReference datastoreMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(datastoreMoId, "Datastore");
        vmDiskSpec.setDatastore(datastoreMor);
        logger.info((Object)"migrate disk settings: diskId=%s, datastoreMoId=%s", new Object[]{vmDiskSpec.getDiskId(), vmDiskSpec.getDatastore().getValue()});
        return vmDiskSpec;
    }

    private String findDatastore(RecoveryProcessorContext contextRef, String datastoreUuId) {
        String datastoreMoId = null;
        List selectedDatastoreList = (List)contextRef.getAttribute("datastoreRefToSelectedVMs");
        for (VsphereDataStore datastore : selectedDatastoreList) {
            String datastoreId = VsphereCommUtil.getDatastoreId(datastore.getUrl());
            if (!Objects.equals(datastoreId, datastoreUuId)) continue;
            datastoreMoId = datastore.getDsMoId();
            break;
        }
        return datastoreMoId;
    }

    public void endRecoveryProcessor() {
        RecoveryProcessorContext context = this.getContextRef();
        VerifyUtil.checkObject((Object)context);
        VerifyUtil.checkObjs((Object[])new Object[]{this.targetVm});
        String vCenter = (String)context.getAttribute("Target_vCenter");
        List<VsphereVirtualMachine> vms = new VMAction().queryAllVms(VmwareConnectionManager.getInstance().getVmwareConnection(vCenter));
        logger.info((Object)"find latest vmPath of vm: vmName=%s, vmMoId=%s", new Object[]{this.targetVm.getName(), this.targetVm.getVmMoId()});
        VsphereVirtualMachine vmFromVCenter = vms.stream().filter(vm -> Objects.equals(vm.getVmMoId(), this.targetVm.getVmMoId())).findAny().orElseThrow(() -> new LegoCheckedException(2117645L));
        this.targetVm.setVmPath(vmFromVCenter.getVmPath());
        Set childProc = this.getParentProc().getChildProc();
        childProc.stream().filter(processor -> processor instanceof RegisterVMSubTask).findFirst().map(processor -> (RegisterVMSubTask)((Object)processor)).orElseThrow(() -> new LegoCheckedException(2117645L)).setVmPath(vmFromVCenter.getVmPath());
        super.endRecoveryProcessor();
    }
}

