/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.SanHyperVaultSwapReplicationProcessor;
import com.huawei.ism.drm.storage.recovery.process.SanHyperVaultSynchronizeReplicationProcessor;
import com.huawei.ism.drm.vsphere.recovery.task.IMigrateVmTask;
import com.huawei.ism.drm.vsphere.recovery.task.MigrateResourceOnlyTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MigrateVMTask
extends BaseRecoveryProcessor {
    public static final String REVERSED_DS_ID_CHANGE_MAP = "reversedDatastoreIdChangeMap";
    private static final Log logger = LogFactory.getInstance(MigrateVMTask.class);
    private static final Map<DrmVsphereEnumDefine.VsphereMigrationTypeE, Class<? extends RecoveryProcessor>> MIGRATION_MAP = new HashMap<DrmVsphereEnumDefine.VsphereMigrationTypeE, Class<? extends RecoveryProcessor>>();

    protected boolean execute(RecoveryProcessorContext context) {
        Class<? extends RecoveryProcessor> operateVmTaskTemplate = this.findOperateVmTaskClass(context);
        if (VerifyUtil.isEmpty(operateVmTaskTemplate)) {
            logger.error((Object)"operateVsphereVmTask is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.reverseDsIdChangeMap(context);
        this.updateMigrateSubProcessors(operateVmTaskTemplate);
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutorSort((Set)this.getChildProc());
        if (!VerifyUtil.isEmpty((Object)executor)) {
            executor.process(context);
        }
        DrmEnumDefine.RecoveryPlanExecuteResultE resultE = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(resultE.getValue());
        return resultE == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS;
    }

    private void reverseDsIdChangeMap(RecoveryProcessorContext context) {
        Map datastoreIdChangeMap = (Map)context.getAttribute("datastoreIdChangeMap");
        if (VerifyUtil.isEmpty((Map)datastoreIdChangeMap)) {
            logger.warn((Object)"datastore id change is empty");
        }
        logger.info((Object)"before reverse datastore map of old -> new: %s", new Object[]{datastoreIdChangeMap});
        HashMap<String, String> reversedDatastoreIdChangeMap = new HashMap<String, String>();
        for (Map.Entry entry : datastoreIdChangeMap.entrySet()) {
            String oldDataDsMoId = (String)entry.getKey();
            String newDataDsMoId = (String)entry.getValue();
            reversedDatastoreIdChangeMap.put(newDataDsMoId, oldDataDsMoId);
        }
        logger.info((Object)"after reverse datastore map of new -> old: %s", new Object[]{reversedDatastoreIdChangeMap});
        context.setAttribute(REVERSED_DS_ID_CHANGE_MAP, reversedDatastoreIdChangeMap);
    }

    private void updateMigrateSubProcessors(Class<? extends RecoveryProcessor> migrateVmTaskTemplate) {
        LinkedHashSet<RecoveryProcessor> childProcessors = new LinkedHashSet<RecoveryProcessor>();
        RecoveryProcessorContext context = this.getContextRef();
        this.addBeforeProcessor(context, childProcessors);
        List targetVms = context.getObjects("Target_VM", VsphereVirtualMachine.class);
        for (VsphereVirtualMachine targetVm : targetVms) {
            RecoveryProcessor migrateVmProcessor = this.createMigrateProcessor(migrateVmTaskTemplate);
            if (migrateVmProcessor instanceof IMigrateVmTask) {
                IMigrateVmTask migrateVmTask = (IMigrateVmTask)migrateVmProcessor;
                migrateVmTask.setTargetVm(context, targetVm);
            }
            migrateVmProcessor.setParentProc((RecoveryProcessor)this);
            childProcessors.add(migrateVmProcessor);
        }
        this.addAfterProcessor(context, childProcessors);
        this.setChildProc(childProcessors);
    }

    protected void addBeforeProcessor(RecoveryProcessorContext context, Set<RecoveryProcessor> childProcessors) {
        if (!this.isHyperVault(context)) {
            return;
        }
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Collection remoteRecoveryTasks = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().getRecoveryTasks(recoveryPlan);
        context.setAttribute("remoteRecoveryTasks", (Object)remoteRecoveryTasks);
        SanHyperVaultSwapReplicationProcessor sanHyperVaultSplitProcess = new SanHyperVaultSwapReplicationProcessor(true, false);
        sanHyperVaultSplitProcess.setProcType(this.getProcType());
        sanHyperVaultSplitProcess.setParentProc((RecoveryProcessor)this);
        sanHyperVaultSplitProcess.setRecoveryTasksKey("remoteRecoveryTasks");
        childProcessors.add((RecoveryProcessor)sanHyperVaultSplitProcess);
    }

    protected void addAfterProcessor(RecoveryProcessorContext context, Set<RecoveryProcessor> childProcessors) {
        if (!this.isHyperVault(context)) {
            return;
        }
        SanHyperVaultSynchronizeReplicationProcessor synchronizeReplicationProcessor = new SanHyperVaultSynchronizeReplicationProcessor();
        synchronizeReplicationProcessor.setParentProc((RecoveryProcessor)this);
        childProcessors.add((RecoveryProcessor)synchronizeReplicationProcessor);
    }

    private boolean isHyperVault(RecoveryProcessorContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        VerifyUtil.checkObjs((Object[])new Object[]{protectGroup});
        PolicyTemplate template = protectGroup.getTemplate();
        VerifyUtil.checkObjs((Object[])new Object[]{template});
        return template.getType() == 30;
    }

    private Class<? extends RecoveryProcessor> findOperateVmTaskClass(RecoveryProcessorContext ctx) {
        Integer migrationTypeValue = (Integer)ctx.getAttribute("migrationtype");
        logger.debug((Object)"migrationType: %s", new Object[]{Collections.singletonList(migrationTypeValue)});
        Optional migrationType = DrmVsphereEnumDefine.VsphereMigrationTypeE.getMigrationType((int)migrationTypeValue);
        Class<? extends RecoveryProcessor> taskClass = MIGRATION_MAP.get(migrationType.orElse(null));
        if (taskClass == null) {
            logger.error((Object)"error migration type: %s", new Object[]{migrationType});
            throw new LegoCheckedException(1073947393L);
        }
        return taskClass;
    }

    private RecoveryProcessor createMigrateProcessor(Class<? extends RecoveryProcessor> taskClass) {
        RecoveryProcessor operateVmTask;
        try {
            operateVmTask = taskClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error((Object)"create migration failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(-1L);
        }
        return operateVmTask;
    }

    static {
        MIGRATION_MAP.put(DrmVsphereEnumDefine.VsphereMigrationTypeE.STORAGE_ONLY, MigrateResourceOnlyTask.class);
    }
}

