/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.UnregisterVMSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.vmware.vim25.ManagedObjectReference;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.RandomStringUtils;

public class RegisterVMSubTask
extends OperateVsphereVmSubTask {
    private static final Log logger = LogFactory.getInstance(UnregisterVMSubTask.class);
    private static final int MAX_VM_NAME_LENGTH = 80;
    private static final int MAX_VM_NAME_BYTE_LENGTH = 214;
    private static final int SPECIAL_CHARACTER_ADDITIONAL_LENGTH = 2;
    private String dcMoId;
    private String vmMoId;
    private String vmName;
    private String vmPath;
    private Boolean isTemplate;

    public RegisterVMSubTask() {
    }

    public RegisterVMSubTask(VsphereVirtualMachine vm, RecoveryProcessor parentProc) {
        super(vm, parentProc);
        this.dcMoId = vm.getDcMoId();
        this.vmName = vm.getName();
        this.vmPath = vm.getVmPath();
        this.isTemplate = vm.getIsTemplate();
    }

    @Override
    protected boolean operateVm(RecoveryProcessorContext context) {
        VsphereVirtualMachine vm = this.getVm();
        this.checkVm(vm);
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        logger.debug((Object)"Register vm, parameter: vm[%s], vCenterUuid[%s]", new Object[]{vm.toString(), vCenterUuid});
        ManagedObjectReference dataCenterMOR = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.dcMoId, "Datacenter");
        String computeResourceUuid = (String)context.getAttribute("computeResourceUuid");
        logger.info((Object)"Register vm, compute resource uuid[%s].", new Object[]{computeResourceUuid});
        ManagedObjectReference compResMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(computeResourceUuid, "ComputeResource");
        VMAction action = new VMAction();
        try {
            ManagedObjectReference virtualMachineMOR = action.findVmByPath(vCenterUuid, this.dcMoId, this.vmPath);
            if (null != virtualMachineMOR) {
                logger.info((Object)"Vm[%s] already registered.", new Object[]{this.vmName});
                return this.setVmMoId(virtualMachineMOR, this.vmName);
            }
            logger.info((Object)("suffix: " + context.getAttribute("NameSuffixKey")));
            if (context.getAttributeKeys().contains("NameSuffixKey")) {
                this.vmName = this.modifyVmName(this.vmName, (String)context.getAttribute("NameSuffixKey"));
                this.updateProcessNameParams(new String[]{this.vmName});
            }
            boolean isTemplateVirtualMachine = vm.getIsTemplate();
            logger.info((Object)"Register vm, isTemplate[%s].", new Object[]{isTemplateVirtualMachine});
            if (isTemplateVirtualMachine) {
                String hostMoId = vm.getHostUuid().split(":")[1];
                virtualMachineMOR = action.registerTemplate(vCenterUuid, dataCenterMOR, hostMoId, this.vmPath, this.vmName);
            } else {
                virtualMachineMOR = action.registerVm(vCenterUuid, dataCenterMOR, compResMor, this.vmPath, this.vmName);
            }
            return this.setVmMoId(virtualMachineMOR, this.vmName);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)String.format("Register vm[%s] failed:", this.vmName), (Throwable)e);
            return this.failure(e);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Register vm[%s] failed:", this.vmName), (Throwable)e);
            return this.failure("lego.err.1073948887", null);
        }
    }

    private void checkVm(VsphereVirtualMachine vm) {
        if (null == vm) {
            logger.error((Object)"Register vm failed, vm is null.");
            this.updateProcessDetail("lego.err.1073947393", null);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public String modifyVmName(String originalVmName, String suffix) {
        if (VerifyUtil.isEmpty((String)suffix)) {
            logger.info((Object)"suffix is null, use original vm name.");
            return originalVmName;
        }
        String newVmName = originalVmName + "_" + RandomStringUtils.randomNumeric((int)4) + "_" + suffix;
        newVmName = this.verifyAndTruncateVMName(newVmName);
        logger.info((Object)"Modify vm name [%s, len: %s] to [%s, len: %s].", new Object[]{originalVmName, originalVmName.length(), newVmName, newVmName.length()});
        return newVmName;
    }

    private boolean setVmMoId(ManagedObjectReference virtualMachineMOR, String registeredVmName) {
        if (null == virtualMachineMOR) {
            logger.error((Object)"Register vm[%s] failed.", new Object[]{registeredVmName});
            return this.failure("lego.err.1073948887", null);
        }
        this.setVmMoId(virtualMachineMOR.getValue());
        this.setVmName(registeredVmName);
        return this.success();
    }

    public String getDcMoId() {
        return this.dcMoId;
    }

    public void setDcMoId(String dcMoId) {
        this.dcMoId = dcMoId;
    }

    public String getVmMoId() {
        return this.vmMoId;
    }

    public void setVmMoId(String vmMoId) {
        this.vmMoId = vmMoId;
    }

    public String getVmPath() {
        return this.vmPath;
    }

    public void setVmPath(String vmPath) {
        this.vmPath = vmPath;
    }

    public String getVmName() {
        return this.vmName;
    }

    public void setVmName(String vmName) {
        this.vmName = vmName;
    }

    public Boolean getIsTemplate() {
        return this.isTemplate;
    }

    public void setIsTemplate(Boolean template) {
        this.isTemplate = template;
    }

    public String verifyAndTruncateVMName(String newVmName) {
        String truncatedName = newVmName;
        int specialCharacterNums = 0;
        for (char ch : truncatedName.toCharArray()) {
            if (ch != '%' && ch != '\\' && ch != '/') continue;
            ++specialCharacterNums;
        }
        int restrictedNameLength = 80 - 2 * specialCharacterNums;
        if (truncatedName.length() > restrictedNameLength) {
            truncatedName = truncatedName.substring(0, restrictedNameLength);
        }
        while (truncatedName.getBytes(StandardCharsets.UTF_8).length > 214) {
            truncatedName = truncatedName.substring(0, truncatedName.length() - 1);
        }
        return truncatedName;
    }
}

