/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmTask;
import com.huawei.ism.drm.vsphere.recovery.task.RegisterVMSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class RegisterVMTask
extends OperateVsphereVmTask {
    private static final Log logger = LogFactory.getInstance(RegisterVMTask.class);

    @Override
    protected OperateVsphereVmSubTask createSubTask(RecoveryProcessorContext context, VsphereVirtualMachine vm) {
        return new RegisterVMSubTask(vm, (RecoveryProcessor)this);
    }

    @Override
    protected boolean doExecute(RecoveryProcessorContext context) {
        return this.executeSubProcessor(context);
    }

    public void endRecoveryProcessor() {
        Set subTasks = this.getChildProc();
        if (!VerifyUtil.isEmpty((Collection)subTasks) && DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            try {
                for (RecoveryProcessor task : subTasks) {
                    RegisterVMSubTask registerVMSubTask = (RegisterVMSubTask)task;
                    this.updateRegisteredVirtualMachineInfo(registerVMSubTask);
                }
                ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
            }
            catch (Exception e) {
                logger.error((Object)"Execute register vm task's EndRecoveryProcessor failed.", (Throwable)e);
            }
        }
        super.endRecoveryProcessor();
    }

    private void updateRegisteredVirtualMachineInfo(RegisterVMSubTask registerVMSubTask) {
        String vmMoId = registerVMSubTask.getVmMoId();
        String vmPath = registerVMSubTask.getVmPath();
        String vmName = registerVMSubTask.getVmName();
        List vmList = this.getContextRef().getObjects("Target_VM", VsphereVirtualMachine.class);
        if (null == vmList) {
            logger.error((Object)"List of vm is null.");
            return;
        }
        for (VsphereVirtualMachine virtualMachine : vmList) {
            String path = virtualMachine.getVmPath();
            if (!vmPath.equals(path)) continue;
            virtualMachine.setVmMoId(vmMoId);
            virtualMachine.setName(vmName);
        }
    }
}

