/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.task.RescanHostSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.List;

public abstract class RescanHostTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(RescanHostTask.class);

    protected boolean execute(RecoveryProcessorContext context) {
        this.createSubTask(context);
        return this.serialExcuteChildProc(context);
    }

    private void createSubTask(RecoveryProcessorContext context) {
        List vsphereHostSystemList = context.getObjects("Target_Host", VsphereHostSystem.class);
        if (null == vsphereHostSystemList) {
            logger.error((Object)"Create rescan vmfs sub task failed, target hsot is null.");
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.2117645", null);
            throw new LegoCheckedException(2117645L);
        }
        HashSet<RescanHostSubTask> subProcessorSet = new HashSet<RescanHostSubTask>();
        for (VsphereHostSystem vsphereHostSystem : vsphereHostSystemList) {
            RescanHostSubTask rescanVmfsSubTask = this.createSubTask(context, vsphereHostSystem);
            rescanVmfsSubTask.setParentProc((RecoveryProcessor)this);
            subProcessorSet.add(rescanVmfsSubTask);
        }
        this.setChildProc(subProcessorSet);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        logger.info((Object)("Create rescan vmfs sub task succeed, task size: " + vsphereHostSystemList.size()));
    }

    protected abstract RescanHostSubTask createSubTask(RecoveryProcessorContext var1, VsphereHostSystem var2);
}

