/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class UnregisterVMSubTask
extends OperateVsphereVmSubTask {
    private static final Log logger = LogFactory.getInstance(UnregisterVMSubTask.class);

    public UnregisterVMSubTask() {
    }

    public UnregisterVMSubTask(VsphereVirtualMachine vm, RecoveryProcessor parentProc) {
        super(vm, parentProc);
    }

    @Override
    protected boolean operateVm(RecoveryProcessorContext context) {
        boolean unregisterResult;
        VsphereVirtualMachine vm = this.getVm();
        if (null == vm) {
            logger.error((Object)"Unregister vm failed, vm is null.");
            return this.failure("lego.err.2117645", null);
        }
        String vmName = vm.getName();
        String vmMoId = vm.getVmMoId();
        String vmPath = vm.getVmPath();
        String dcMoId = vm.getDcMoId();
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        logger.debug((Object)"Unregister vm, parameter: vm[%s], vCenterUuid[%s]", new Object[]{vm.toString(), vCenterUuid});
        this.updateProcessNameParams(new String[]{vmName});
        VMAction vmAction = new VMAction();
        if (null == vmAction.findVmByPath(vCenterUuid, dcMoId, vmPath)) {
            logger.info((Object)"Vm[%s] already unregistered in vCenter[%s] and DataCenter[%s].", new Object[]{vmName, vCenterUuid, dcMoId});
            return this.success("ism.drm.recovery.vsphere.vm.unregister.already", new String[]{vmName});
        }
        try {
            unregisterResult = vmAction.unregisterVM(vCenterUuid, vmMoId);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Unregister vm[%s, %s] from vCenter[%s] failed.", new Object[]{vmMoId, vmName, vCenterUuid});
            return this.failure(e);
        }
        if (!unregisterResult) {
            logger.error((Object)"Unregister vm[%s] from vCenter[%s] failed.", new Object[]{vmName, vCenterUuid});
            return this.failure("ism.drm.recovery.vsphere.vm.unregister.failed", new String[]{vmName});
        }
        logger.info((Object)"Unregister vm[%s] from vCenter[%s] succeed.", new Object[]{vmName, vCenterUuid});
        return this.success();
    }
}

