/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.AbstractRecoveryTaskInterceptor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public class VMwareRecoveryTaskInterceptor
extends AbstractRecoveryTaskInterceptor {
    private static final Log logger = LogFactory.getInstance(VMwareRecoveryTaskInterceptor.class);

    public VMwareRecoveryTaskInterceptor(BaseRecoveryProcessor processor) {
        super(processor);
    }

    public boolean before() {
        BaseRecoveryProcessor processor = this.getInterceptTask();
        RecoveryProcessorContext context = processor.getContextRef();
        if (null == context) {
            logger.error((Object)"Recovery context is null");
            throw new LegoCheckedException(1073947393L);
        }
        String targetHostType = (String)processor.getProps().get("targethosttype");
        if (null != targetHostType) {
            context.setAttribute("TargetHostKey", (Object)targetHostType);
        }
        String recoveryNetworkType = (String)processor.getProps().get("recoverynetworktype");
        context.setAttribute("recoverynetworktype", (Object)recoveryNetworkType);
        ProtectGroup protectGroup = context.getProtectGroup();
        if (null == protectGroup) {
            logger.error((Object)"Protect group cannot be null");
            throw new LegoCheckedException(1073947393L, "Protect Group cannot be null");
        }
        List protectObjectStorageInfoList = protectGroup.distinctStorageInfo();
        if (null == protectObjectStorageInfoList || protectObjectStorageInfoList.isEmpty()) {
            logger.error((Object)"Protect object storage is null %s", new Object[]{protectObjectStorageInfoList});
            throw new LegoCheckedException(1073947393L);
        }
        this.prepareTargetVirtualMachine(context);
        this.prepareTargetHost(context);
        this.prepareTargetDatastore(context);
        this.prepareTargetStoreageResource(context);
        this.prepareTargetVCenter(context);
        return true;
    }

    protected void prepareTargetVirtualMachine(RecoveryProcessorContext context) {
    }

    protected void prepareTargetHost(RecoveryProcessorContext context) {
    }

    protected void prepareTargetStoreageResource(RecoveryProcessorContext context) {
    }

    protected void prepareTargetDatastore(RecoveryProcessorContext context) {
    }

    protected void prepareTargetVCenter(RecoveryProcessorContext context) {
    }
}

