/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopyProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateSnapshotCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SanHyperVaultSwapReplicationProcessor;
import com.huawei.ism.drm.storage.recovery.process.SanHyperVaultSynchronizeReplicationProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsCheckRdmRollbackProcessor;
import com.huawei.ism.drm.vsphere.recovery.process.VsRdmRollbackProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class VmRollbackRdmTask
extends BaseRecoveryProcessor {
    public static final String RDM_WWN_KEY = "rdmWwnKey";
    private static final String SNAPSHOT_CHILD_KEY = "snapshotCopyForVmRecovery";
    private static final Log logger = LogFactory.getInstance(VmRollbackRdmTask.class);
    private Set<String> rdmWwn;

    protected boolean execute(RecoveryProcessorContext context) {
        this.rdmWwn = (Set)context.getAttribute(RDM_WWN_KEY);
        if (VerifyUtil.isEmpty(this.rdmWwn)) {
            logger.error((Object)"rdm wwn set is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate template = context.getProtectGroup().getTemplate();
        logger.info((Object)"rollback for template type: %s", new Object[]{template});
        if (template.getType() == PolicyTemplateType.PolicyTemplateE.ARRAY_SAN_HYPERVAULT.getValue()) {
            this.updateVaultSubProcessors(context);
        } else if (template.getType() == PolicyTemplateType.PolicyTemplateE.ARRAY_SNAPSHOT.getValue()) {
            this.updateSnapshotProcessors(context);
        } else {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutorSort((Set)this.getChildProc());
        if (VerifyUtil.isEmpty((Object)executor)) {
            logger.error((Object)"vm rollback rdm no child processor.");
            throw new LegoCheckedException(1073947393L);
        }
        executor.process(context);
        this.calcProcessResultBySubProc();
        return this.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
    }

    private void updateVaultSubProcessors(RecoveryProcessorContext context) {
        LinkedHashSet<Object> childProcessor = new LinkedHashSet<Object>();
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Collection remoteRecoveryTasks = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().getRecoveryTasks(recoveryPlan);
        context.setAttribute("remoteRecoveryTasks", (Object)remoteRecoveryTasks);
        SanHyperVaultSwapReplicationProcessor sanHyperVaultSplitProcess = new SanHyperVaultSwapReplicationProcessor(true, false);
        sanHyperVaultSplitProcess.setProcType(this.getProcType());
        sanHyperVaultSplitProcess.setParentProc((RecoveryProcessor)this);
        sanHyperVaultSplitProcess.setRecoveryTasksKey("remoteRecoveryTasks");
        childProcessor.add(sanHyperVaultSplitProcess);
        Set<RecoveryProcessor> snapshotSubProcessor = this.getCreateSnapshotSubProcessor();
        childProcessor.add((Object)new VsRdmRollbackProcessor(snapshotSubProcessor, (RecoveryProcessor)this));
        childProcessor.add((Object)new VsCheckRdmRollbackProcessor(snapshotSubProcessor, (RecoveryProcessor)this, ReplicationConstantDefine.LocalTaskType.SNAPSHOT));
        SanHyperVaultSynchronizeReplicationProcessor synchronizeReplicationProcessor = new SanHyperVaultSynchronizeReplicationProcessor();
        synchronizeReplicationProcessor.setParentProc((RecoveryProcessor)this);
        childProcessor.add(synchronizeReplicationProcessor);
        this.setChildProc(childProcessor);
    }

    private Set<RecoveryProcessor> getCreateSnapshotSubProcessor() {
        RecoveryProcessor parentProc = this.getParentProc();
        RecoveryProcessorContext contextRef = this.getContextRef();
        VerifyUtil.checkObjs((Object[])new Object[]{parentProc, contextRef});
        CreateSnapshotCopyProcessor copyProcessor = (CreateSnapshotCopyProcessor)contextRef.getAttribute(SNAPSHOT_CHILD_KEY);
        if (VerifyUtil.isEmpty((Object)copyProcessor)) {
            logger.error((Object)"can't find copy processor.");
            throw new LegoCheckedException(1073947393L);
        }
        Set childProc = copyProcessor.getChildProc();
        HashSet<RecoveryProcessor> newChildSet = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor recoveryProcessor : childProc) {
            CreateSnapshotCopySubProcessor copySubProcessor;
            String srcSnapshotIdKey;
            if (!(recoveryProcessor instanceof CreateSnapshotCopySubProcessor) || !this.rdmWwn.contains(srcSnapshotIdKey = (copySubProcessor = (CreateSnapshotCopySubProcessor)recoveryProcessor).getDeviceId() + ":" + copySubProcessor.getSrcSnapshotId())) continue;
            newChildSet.add((RecoveryProcessor)copySubProcessor);
        }
        return newChildSet;
    }

    private void updateSnapshotProcessors(RecoveryProcessorContext context) {
        throw new LegoCheckedException(102410L);
    }

    private Set<CreateSnapshotCopyProcessor> getRdmSnapshotCopyProcessor(RecoveryProcessorContext context) {
        return Collections.emptySet();
    }

    private <T extends RecoveryProcessor> T findPreviousProcess(RecoveryProcessor parentProc, Class<T> createSnapshotCopyProcessorClass) {
        RecoveryProcessor tmp = parentProc;
        do {
            if (!createSnapshotCopyProcessorClass.isInstance(tmp)) continue;
            return (T)tmp;
        } while ((tmp = tmp.getPreviousProcessor()) != null);
        return (T)tmp;
    }
}

