/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.utils;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.vsphere.adapter.action.DataCenterAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.sdk.model.VmVirtualDisk;
import com.huawei.ism.drm.vsphere.sdk.model.VsDataCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsVirtualEthernetCard;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.drm.vsphere.tools.VsVMObjectHelper;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VsphereVirtualMachineUtils {
    private static final Log logger = LogFactory.getInstance(VsphereVirtualMachineUtils.class);
    private static final String SHUTDOWN_VM_TIMEOUT_CONFIG_KEY = "vmware.shutdown.vm.timeout";

    public static boolean isVMPowerStateEquals(String vmManagedObjectId, String vcenterUuid, VirtualMachinePowerState expectedState) {
        VMAction vmAction = new VMAction();
        boolean ret = false;
        long minWaitTime = 2000L;
        long waitTime = 20000L;
        long timeout = LegoConfig.getInstance().getNumber(SHUTDOWN_VM_TIMEOUT_CONFIG_KEY, 600L) * 1000L;
        long totalTime = 0L;
        try {
            while (true) {
                VirtualMachinePowerState status;
                if (expectedState == (status = vmAction.getVMPowerState(vcenterUuid, vmManagedObjectId))) {
                    ret = true;
                    break;
                }
                if ((totalTime += waitTime) >= timeout) {
                    ret = false;
                    break;
                }
                Thread.sleep(waitTime);
                waitTime = waitTime <= minWaitTime ? minWaitTime : waitTime / 2L;
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"shutdown  VM failed: thread interuptted", 90160758786989L);
            return false;
        }
        return ret;
    }

    public static VsDataCenter findDataCenter(VsphereVirtualMachine virtualMachine, String vCenterUuid) {
        HashMap<String, String> props = new HashMap<String, String>();
        VsVMObjectHelper.setVmConfigToProps(props, virtualMachine);
        String networkSetting = (String)props.get("VirtualEthernetCard");
        return VsphereVirtualMachineUtils.solveVsDataCenter(vCenterUuid, networkSetting);
    }

    public static VsDataCenter solveVsDataCenter(String vCenterUuid, String networkSetting) {
        JSONArray jsonArr = JSONArray.fromObject((Object)networkSetting);
        if (VerifyUtil.isEmpty((Collection)jsonArr)) {
            logger.error((Object)"networkSetting is empty");
            return null;
        }
        String netWorkUuid = jsonArr.getJSONObject(0).getString("netWorkUuid");
        netWorkUuid = netWorkUuid.split(":")[1];
        DataCenterAction action = new DataCenterAction();
        List<VsDataCenter> list = action.queryVsphereDataCenter(vCenterUuid);
        VsDataCenter result = null;
        for (VsDataCenter dc : list) {
            if (!dc.getNetWorks().contains(netWorkUuid)) continue;
            result = dc;
            break;
        }
        return result;
    }

    public static VsphereVirtualMachine convertFrom(ProtectObject protectObject) {
        if (protectObject == null) {
            return null;
        }
        VsphereVirtualMachine virtualMachine = new VsphereVirtualMachine();
        virtualMachine.setName(protectObject.getName());
        String vmPath = protectObject.getProperty("VMPATH");
        virtualMachine.setVmPath(vmPath);
        String value = protectObject.getProperty("ISTEMPLATE");
        virtualMachine.setIsTemplate(Boolean.valueOf("true".equals(value)));
        virtualMachine.setHostUuid(protectObject.getProperty("HOSTUUID"));
        String protectObjectMoUuid = protectObject.getMoUuid();
        if (protectObjectMoUuid != null && protectObjectMoUuid.contains(":")) {
            virtualMachine.setVmMoId(protectObjectMoUuid.split(":")[1]);
        }
        virtualMachine.setUuid(protectObject.getUuid());
        String hostName = protectObject.getProperty("GUESTHOSTNAME");
        virtualMachine.setHostName(hostName);
        String guestFamily = protectObject.getProperty("GUESTOSTYPE");
        virtualMachine.setGuestFamily(guestFamily);
        String key = "VirtualEthernetCard";
        virtualMachine.setVirtualEthernetCardList(protectObject.getProperties(key, VsVirtualEthernetCard.class));
        virtualMachine.setVirtualDisk(VsphereVirtualMachineUtils.loadVMVirtualDisk(protectObject));
        return virtualMachine;
    }

    private static Set<VmVirtualDisk> loadVMVirtualDisk(ProtectObject protectObject) {
        HashSet<VmVirtualDisk> virtualDisks = new HashSet<VmVirtualDisk>();
        Set storageInfoSet = protectObject.getUsedStorageResourceSet();
        if (null == storageInfoSet || storageInfoSet.isEmpty()) {
            return virtualDisks;
        }
        for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
            String mnt = storageInfo.getMountPoint();
            if (null == mnt) {
                logger.error((Object)"Cannot find Datastore mountPoint from protectObject storage");
                continue;
            }
            String dsUuid = mnt.substring("ds:///vmfs/volumes/".length(), mnt.length() - 1);
            int storageType = storageInfo.getStorageType();
            VmVirtualDisk disk = new VmVirtualDisk();
            disk.setDiskType(storageType);
            disk.setDataStoreOrLunUuid(dsUuid);
            disk.setDatastoreId(dsUuid);
            disk.setStorageType(DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.getType((int)storageType).name());
            if (storageType == DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue() || storageType == DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue()) {
                disk.setDataStoreOrLunUuid(storageInfo.getLunWWN());
                disk.setStorageFileName(storageInfo.getDeviceName());
                disk.setContentDataStoreUuid(dsUuid);
                disk.setSharing(storageInfo.getStorageShareType());
            }
            virtualDisks.add(disk);
        }
        return virtualDisks;
    }
}

