/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.service.impl;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.virtualization.sdk.model.HostSystem;
import com.huawei.ism.drm.virtualization.sdk.model.NonCriticalVm;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.ism.drm.vsphere.adapter.action.DataCenterAction;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.sdk.model.DrVsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsDataCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereComputeResource;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VspherePhysicalStorageDevice;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereResourcePool;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.service.IVsphereRecoveryService;
import com.huawei.ism.drm.vsphere.sdk.service.IVsphereService;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.query.Query;

@Service(name="com.huawei.ism.drm.vsphere.sdk.service.IVsphereRecoveryService", desc="", interfaceClass=IVsphereRecoveryService.class)
public class VsphereRecoveryServiceImpl
extends BaseService
implements IVsphereRecoveryService {
    private static final Log logger = LogFactory.getInstance(VsphereRecoveryServiceImpl.class);

    public DrVsphereCenter getRecoveryVCenterByPlanId(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        if (null == recoveryPlanService) {
            throw new LegoCheckedException(1073947395L);
        }
        RecoveryPlan plan = recoveryPlanService.getRecoveryPlan(planId);
        if (null == plan || VerifyUtil.isEmpty((Collection)plan.getProtectGroups())) {
            logger.info((Object)("there is no plan marked as " + planId), 90160758784000L);
            return null;
        }
        List<String> lunWwns = this.getAllLunWwns(plan);
        List<VspherePhysicalStorageDevice> disks = this.getPhysicalDiskByLunWwn(lunWwns);
        HashSet<String> vCenterIds = new HashSet<String>();
        for (VspherePhysicalStorageDevice vspherePhysicalStorageDevice : disks) {
            vCenterIds.add(vspherePhysicalStorageDevice.getTopMoUuid());
        }
        if (vCenterIds.size() > 1) {
            logger.error((Object)("there are more than on vcenter matched by plan " + planId), 90160758784001L);
            throw new LegoCheckedException(1073948902L);
        }
        String vCenterSn = "";
        Iterator iterator = vCenterIds.iterator();
        if (iterator.hasNext()) {
            String s;
            vCenterSn = s = (String)iterator.next();
        }
        if (VerifyUtil.isEmpty((String)vCenterSn)) {
            return null;
        }
        DrVsphereCenter drVsphereCenter = (DrVsphereCenter)((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(vCenterSn, "ism.drm.deviceType.drvsphere.mainType");
        return drVsphereCenter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VspherePhysicalStorageDevice> getPhysicalDiskByLunWwn(List<String> lunWwns) {
        List params;
        Session session;
        ArrayList<VspherePhysicalStorageDevice> disks;
        String hql;
        block8: {
            hql = "from VspherePhysicalStorageDevice where storageWwn in (:wwns)";
            disks = new ArrayList<VspherePhysicalStorageDevice>();
            session = null;
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            if (null == session) {
                throw new LegoCheckedException("get session is null.");
            }
            params = DBOperationUtil.createBatchQueryParameters(lunWwns, (int)15);
            if (null != params && !params.isEmpty()) break block8;
            logger.warn((Object)"params is null.", 90160758784001L);
            ArrayList<VspherePhysicalStorageDevice> arrayList = disks;
            DBOperationUtil.closeSession((Session)session);
            return arrayList;
        }
        try {
            for (List param : params) {
                Query query = session.createQuery(hql);
                query.setParameterList("wwns", (Collection)param);
                List result = query.list();
                if (null == result) continue;
                for (Object object : result) {
                    disks.add((VspherePhysicalStorageDevice)object);
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)("Batch quering luns by device sn failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
        return disks;
    }

    private List<String> getAllLunWwns(RecoveryPlan plan) {
        logger.debug((Object)"getAllLunWwns start");
        ArrayList tgtLunIds = new ArrayList();
        ArrayList replicationRelations = new ArrayList();
        Set protectGroups = plan.getProtectGroups();
        Iterator itr = protectGroups.iterator();
        String disasterSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
        while (itr.hasNext()) {
            ProtectGroup pg = (ProtectGroup)itr.next();
            List replicationRelationBoList = pg.getReplicationRelationByRecoverySiteId(disasterSiteId);
            if (replicationRelationBoList.isEmpty()) continue;
            replicationRelations.addAll(replicationRelationBoList);
        }
        String tgtDeviceSn = "";
        for (ReplicationRelationBo bo : replicationRelations) {
            tgtDeviceSn = bo.getTgtDeviceSn();
            tgtLunIds.addAll(bo.getTgtLuns().values());
        }
        List tgtLuns = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getLunsByDeviceSnAndLunIds(tgtDeviceSn, tgtLunIds);
        ArrayList<String> lunWwns = new ArrayList<String>();
        for (Lun lun : tgtLuns) {
            lunWwns.add(lun.getWwn());
        }
        return lunWwns;
    }

    public String getAvailableNonCriticalVms(String vcenterUuid, String hostOrClusterId) {
        if (VerifyUtil.isEmpty((String)vcenterUuid) || VerifyUtil.isEmpty((String)hostOrClusterId)) {
            logger.error((Object)"vcenterUuid or hostOrClusterId is empty", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        DrVsphereCenter vcenter = ((IVsphereService)ServiceLocator.getInstance().getService(IVsphereService.class)).getDrVsphereCenter(vcenterUuid);
        if (null == vcenter) {
            logger.error((Object)"vcenter is not existed.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        String ret = new JSONArray().toString();
        ret = this.getAvailableNonCriticalVmsOnLocalSite(vcenterUuid, hostOrClusterId, ret);
        logger.debug((Object)("get running vms:" + ret), 90160758786816L);
        return ret;
    }

    private String getAvailableNonCriticalVmsOnLocalSite(String vcenterUuid, String hostOrClusterId, String ret) {
        VsphereComputeResource compRes = (VsphereComputeResource)CommonDAOLocator.getMoDao().getMo(VsphereComputeResource.class, "uuid", (Object)hostOrClusterId);
        if (null == compRes || !vcenterUuid.equals(compRes.getTopMoUuid())) {
            logger.error((Object)"compRes is not existed or not match vcenter.", 90160758786989L);
            throw new LegoCheckedException(1073947393L);
        }
        List resPoolList = CommonDAOLocator.getMoDao().getAllSubMo(compRes.getMoId().longValue(), VsphereResourcePool.class);
        ArrayList vmList = new ArrayList();
        for (VsphereResourcePool pool : resPoolList) {
            String poolUuid = pool.getUuid();
            vmList.addAll(CommonDAOLocator.getMoDao().getMoList(VsphereVirtualMachine.class, "resourcePoolUuid", (Object)poolUuid));
        }
        ArrayList<NonCriticalVm> nonCriticalVmList = new ArrayList<NonCriticalVm>();
        for (VsphereVirtualMachine vsVm : vmList) {
            NonCriticalVm nonCriticalVm = new NonCriticalVm();
            nonCriticalVm.setName(vsVm.getName());
            nonCriticalVm.setUuid(vsVm.getUuid());
            nonCriticalVmList.add(nonCriticalVm);
        }
        if (!VerifyUtil.isEmpty(nonCriticalVmList)) {
            this.sortVms(nonCriticalVmList);
            ret = JSONArray.fromObject(nonCriticalVmList).toString();
        }
        return ret;
    }

    private void sortVms(List<NonCriticalVm> vmList) {
        logger.debug((Object)"sortVms start");
        Collections.sort(vmList, new Comparator<NonCriticalVm>(){

            @Override
            public int compare(NonCriticalVm vm1, NonCriticalVm vm2) {
                if (VerifyUtil.isEmpty((String)vm1.getName()) || VerifyUtil.isEmpty((Object)vm2)) {
                    return -1;
                }
                return vm1.getName().compareTo(vm2.getName());
            }
        });
    }

    public String getSelNonCriticalVms(String planId) {
        RecoveryPlan recoveryPlan = this.getRpService().getRecoveryPlan(planId);
        Map globalSetting = recoveryPlan.getGlobalSettings();
        if (VerifyUtil.isEmpty((Map)globalSetting) || VerifyUtil.isEmpty((String)((String)globalSetting.get("NoncritialVM")))) {
            logger.info((Object)("recoveryPlan " + recoveryPlan.getName() + "globalSetting or the noncriticalvm is null "), 90160758786816L);
            return new JSONArray().toString();
        }
        String json = (String)globalSetting.get("NoncritialVM");
        JSONArray jsonArr = JSONArray.fromObject((Object)json);
        List vmList = JSONArray.toCollection((JSONArray)jsonArr, NonCriticalVm.class);
        ArrayList<NonCriticalVm> retList = new ArrayList<NonCriticalVm>();
        for (NonCriticalVm vm : vmList) {
            VsphereVirtualMachine vsVm = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)vm.getUuid());
            if (null == vsVm) continue;
            vm.setName(vsVm.getName());
            retList.add(vm);
        }
        String ret = new JSONArray().toString();
        if (!VerifyUtil.isEmpty(retList)) {
            this.sortVms(retList);
            ret = JSONArray.fromObject(retList).toString();
        }
        logger.debug((Object)("selected vms " + ret), 90160758786816L);
        return ret;
    }

    private IRecoveryPlanService getRpService() {
        logger.debug((Object)"getRpService start");
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        if (null == recoveryPlanService) {
            throw new LegoCheckedException(1073947395L);
        }
        return recoveryPlanService;
    }

    public Map<String, HostSystem> getRecoveryEsxLunMappingByPlanId(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanService recoveryPlanService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        if (null == recoveryPlanService) {
            throw new LegoCheckedException(1073947395L);
        }
        RecoveryPlan plan = recoveryPlanService.getRecoveryPlan(planId);
        if (null == plan || VerifyUtil.isEmpty((Collection)plan.getProtectGroups())) {
            logger.info((Object)("there is no plan marked as " + planId), 90160758784000L);
            return null;
        }
        List<String> lunWwns = this.getAllLunWwns(plan);
        List<VspherePhysicalStorageDevice> disks = this.getPhysicalDiskByLunWwn(lunWwns);
        HashMap<String, HostSystem> hostLunMap = new HashMap<String, HostSystem>();
        for (VspherePhysicalStorageDevice disk : disks) {
            hostLunMap.put(disk.getStorageWwn(), (HostSystem)disk.getParentMo());
        }
        return hostLunMap;
    }

    public boolean stopVm(String planId, String vmMoId, String vcenterUuid) {
        String vmxPath;
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)vmMoId) || VerifyUtil.isEmpty((String)vcenterUuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        VMAction vmAction = new VMAction();
        RecoveryPlan plan = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).getRecoveryPlan(planId);
        String dcMoId = this.getDatacenterId(plan);
        if (vmAction.findVmByPath(vcenterUuid, dcMoId, vmxPath = this.getVmxPath(vmMoId)) == null) {
            logger.info((Object)("vm already deleted: " + vmMoId), 90160758786988L);
            return true;
        }
        VirtualMachinePowerState powerState = vmAction.getVMPowerState(vcenterUuid, vmMoId);
        VirtualMachineToolsRunningStatus toolRunningState = vmAction.getGuestVMToolState(vcenterUuid, vmMoId);
        if (VirtualMachinePowerState.POWERED_ON == powerState && VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING != toolRunningState) {
            logger.error((Object)("this vmtools is not running" + vmMoId), 90160758786989L);
            throw new LegoCheckedException(1073948868L);
        }
        vmMoId = this.removePrefix(vmMoId);
        ManagedObjectReference vmMor = new ManagedObjectReference();
        vmMor.setType("VirtualMachine");
        vmMor.setValue(vmMoId);
        DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E state = vmAction.getGuestOSState(vcenterUuid, vmMor);
        if (state != DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E.NOTRUNNING) {
            logger.info((Object)("vm " + vmMoId + "status is " + state + ", shutdown it"), 90160758786988L);
            vmAction.shutdownGuest(vcenterUuid, vmMoId);
            if (!this.checkVmShutdownResultAndWait(vcenterUuid, vmMoId)) {
                throw new LegoCheckedException(-1L);
            }
        }
        logger.debug((Object)("shutdown vm succ " + vmMoId), 90160758786988L);
        vmAction.unregisterVM(vcenterUuid, vmMoId);
        logger.debug((Object)("remove from list vm succ " + vmMoId), 90160758786988L);
        return true;
    }

    private String getDatacenterId(RecoveryPlan plan) {
        String dcId = null;
        try {
            VirtualizationCommonUtil util = VirtualizationCommonUtil.getInstance();
            ProtectGroup pg = (ProtectGroup)util.getElementFromCollection((Collection)plan.getProtectGroups());
            String vcenterSn = pg.getPoProviderSN();
            if (!pg.getPolist().iterator().hasNext()) {
                throw new LegoCheckedException(1073947393L);
            }
            String networkSetting = (String)((ProtectObject)pg.getPolist().iterator().next()).getProps().get("VirtualEthernetCard");
            JSONArray jsonArr = JSONArray.fromObject((Object)networkSetting);
            String netWorkUuid = jsonArr.getJSONObject(0).getString("netWorkUuid");
            netWorkUuid = netWorkUuid.split(":")[1];
            DataCenterAction action = new DataCenterAction();
            List<VsDataCenter> list = action.queryVsphereDataCenter(vcenterSn);
            for (VsDataCenter dc : list) {
                if (!dc.getNetWorks().contains(netWorkUuid)) continue;
                dcId = dc.getMoId();
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("getDatacenterId failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return dcId;
    }

    private String getVmxPath(String uuid) {
        String vmUuid = null;
        VsphereVirtualMachine vsVm = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)uuid);
        if (null != vsVm) {
            vmUuid = vsVm.getVmPath();
        } else {
            logger.error((Object)("cant find VirtualMachine by uuid,uuid=" + uuid), 90160758786989L);
        }
        return vmUuid;
    }

    public String getVmNameFromDb(String moUuid) {
        String vmName = moUuid;
        VsphereVirtualMachine vsVm = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)moUuid);
        if (null != vsVm) {
            vmName = vsVm.getName();
        } else {
            logger.error((Object)("cant find VirtualMachine from Db,uuid=" + moUuid), 90160758786989L);
        }
        return vmName;
    }

    public String getDatastoreNameFromDb(String url) {
        String dsName = url;
        VsphereDataStore datastore = (VsphereDataStore)CommonDAOLocator.getMoDao().getMo(VsphereDataStore.class, "url", (Object)url);
        if (null != datastore) {
            dsName = datastore.getName();
        } else {
            logger.error((Object)("cant find VsphereDataStore from Db,uuid=" + url), 90160758786989L);
        }
        return dsName;
    }

    public boolean removeNasDatastore(String vcenterUuid, String compResUuid, String dsUuid, String dsName) {
        logger.debug((Object)("removeNasDatastore start:dsName=" + dsName));
        DataStoreAction action = new DataStoreAction();
        action.removeDsFromCompRes(vcenterUuid, compResUuid, dsUuid);
        return true;
    }

    public boolean unmountDataStore(String planId, String datastoreUuid, String vcenterUuid) {
        logger.debug((Object)("unmountDataStore start:datastoreUuid=" + datastoreUuid));
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)datastoreUuid) || VerifyUtil.isEmpty((String)vcenterUuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        HostSystemAction hostAction = new HostSystemAction();
        datastoreUuid = this.removePrefix(datastoreUuid);
        hostAction.unmountDataStoreByUuid(vcenterUuid, datastoreUuid);
        return true;
    }

    public boolean unmountScsiLun(String planId, String lunWwn, String vcenterUuid) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)lunWwn) || VerifyUtil.isEmpty((String)vcenterUuid)) {
            throw new LegoCheckedException(1073947393L);
        }
        HostSystemAction hostAction = new HostSystemAction();
        if (!VerifyUtil.isEmpty((String)lunWwn)) {
            String hostSn = this.getHostMoIdByLunWwn(lunWwn);
            hostSn = this.removePrefix(hostSn);
            hostAction.unmountScsiLunByWwn(vcenterUuid, hostSn, lunWwn);
            logger.debug((Object)("unmount lun wwn " + lunWwn + " by mo id " + hostSn), 90160758786988L);
        }
        return true;
    }

    private boolean checkVmShutdownResultAndWait(String vcenterUuid, String vmManagedObjectId) {
        VMAction vmAction = new VMAction();
        ManagedObjectReference mor = new ManagedObjectReference();
        mor.setType("VirtualMachine");
        mor.setValue(vmManagedObjectId);
        for (int i = 0; i < 10; ++i) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"shutdown  VM failed: thread interuptted", 90160758786989L);
                return false;
            }
            DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E status = vmAction.getGuestOSState(vcenterUuid, mor);
            if (status == DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E.NOTRUNNING) {
                return true;
            }
            logger.info((Object)("vm status is  " + status + ", continue waiting"), 90160758786988L);
        }
        return false;
    }

    private String removePrefix(String uuid) {
        logger.debug((Object)"removePrefix start");
        String result = uuid;
        if (VerifyUtil.isEmpty((String)uuid)) {
            return result;
        }
        if (uuid.contains(":")) {
            result = uuid.split(":")[1];
        }
        return result;
    }

    private String getHostMoIdByLunWwn(String lunWwn) {
        logger.debug((Object)("getHostMoIdByLunWwn start:lunWwn=" + lunWwn));
        VspherePhysicalStorageDevice storageDevice = (VspherePhysicalStorageDevice)CommonDAOLocator.getMoDao().getMo(VspherePhysicalStorageDevice.class, "storageWwn", (Object)lunWwn);
        return storageDevice.getParentMo().getUuid();
    }
}

