/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.service.impl;

import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;

public class VsphereVmLicenseCheckObserverImpl
implements IObjectObserver {
    private static final Log logger = LogFactory.getInstance(VsphereVmLicenseCheckObserverImpl.class);
    private ISiteResourceService vsphereResService;

    public void setVsphereResService(ISiteResourceService vsphereResService) {
        this.vsphereResService = vsphereResService;
    }

    public void before(MessageEvent event) {
        VirtualizationCommonUtil commonUtil = VirtualizationCommonUtil.getInstance();
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            if (!(object instanceof ProtectGroup)) continue;
            ProtectGroup protectGroup = (ProtectGroup)object;
            if (!this.isNeedToCheck(protectGroup)) {
                logger.debug((Object)("pg is not need to check:" + protectGroup.getName()));
                continue;
            }
            if (messageType == 0) {
                logger.debug((Object)("begin check License for pg:" + protectGroup.getName()));
                commonUtil.checkLicense(protectGroup.getTemplate().getType(), protectGroup.getPoCount());
            }
            if (messageType != 3) continue;
            ProtectGroup curPg = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid());
            int addPoCount = protectGroup.getPoCount() - curPg.getPoCount();
            logger.debug((Object)("begin check License for pg:" + protectGroup.getName()));
            commonUtil.checkLicense(protectGroup.getTemplate().getType(), addPoCount);
        }
    }

    private boolean isNeedToCheck(ProtectGroup protectGroup) {
        if (10 != protectGroup.getPoType()) {
            logger.debug((Object)("pg is not need to check:" + protectGroup.getName()));
            return false;
        }
        DrResource vCenter = this.vsphereResService.getDrResourceBySn(protectGroup.getPoProviderSN());
        if (null == vCenter) {
            logger.debug((Object)("vCenter is null:" + protectGroup.getPoProviderSN()));
            return false;
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(vCenter.getSiteId());
        if (null == site) {
            logger.debug((Object)("site is null or is not in local:" + vCenter.getSiteId()));
            return false;
        }
        return true;
    }

    public void after(MessageEvent event) {
        List objectList = event.getObjectList();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Collection)objectList)) {
            return;
        }
        for (DRMObject object : objectList) {
            ILicenseControl licenseCtr;
            if (!(object instanceof ProtectGroup)) continue;
            ProtectGroup protectGroup = (ProtectGroup)object;
            if (!this.isNeedToCheck(protectGroup)) {
                logger.debug((Object)("pg is not need to check:" + protectGroup.getName()));
                continue;
            }
            if (messageType == 0 || messageType == 3) {
                logger.debug((Object)("begin check License for pg:" + protectGroup.getName()));
                licenseCtr = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
                licenseCtr.checkLicenseOutOfControlAlarm();
            }
            if (messageType != 2 && messageType != 4) continue;
            logger.debug((Object)("begin check License for pg:" + protectGroup.getName()));
            licenseCtr = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
            licenseCtr.checkLicenseOutOfControlAlarm(true);
        }
    }

    public String getObserverType() {
        return ProtectGroup.class.getName();
    }
}

