/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.tools;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.virtualization.sdk.model.DataStoreInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VmDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStoreDiskInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereResourcePool;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Session;

public class VsVMObjectHelper {
    private static final List<Integer> SUPPORT_VIRTUAL_DISK_TYPES = Arrays.asList(DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VMFS.getValue(), DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue(), DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue());
    private static final Log logger = LogFactory.getInstance(VsVMObjectHelper.class);
    private static final List<Integer> replicationTypes = Arrays.asList(0, 1, 20, 18, 15, 24, 23);
    private static final List<Integer> snapShotTypes = Arrays.asList(2, 14, 19, 17, 28);
    private static final VsVMObjectHelper instance = new VsVMObjectHelper();

    public static VsVMObjectHelper getInstance() {
        return instance;
    }

    public static void setVmConfigToProps(Map<String, String> props, VsphereVirtualMachine vm) {
        String vmConfig = vm.getVmConfig();
        JSONArray jsonArray = JSONArray.fromObject((Object)vmConfig);
        JSONArray networkJsonArray = new JSONArray();
        JSONArray virtualDiskJsonArray = new JSONArray();
        VsVMObjectHelper.getNetWorkAndDiskJsonInfo(jsonArray, networkJsonArray, virtualDiskJsonArray);
        props.put("VirtualEthernetCard", networkJsonArray.toString());
        props.put("VirtualDisk", virtualDiskJsonArray.toString());
    }

    private static void getNetWorkAndDiskJsonInfo(JSONArray jsonArray, JSONArray networkJsonArray, JSONArray virtualDiskJsonArray) {
        logger.debug((Object)"getNetWorkAndDiskJsonInfo start");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            JSONObject newObject = new JSONObject();
            if (object.containsValue((Object)"VirtualEthernetCard")) {
                newObject.put((Object)"macAddress", object.get("macAddress"));
                newObject.put((Object)"netWorkUuid", object.get("netWorkUuid"));
                newObject.put((Object)"netWorkName", object.get("netWorkName"));
                newObject.put((Object)"ethernetCardName", object.get("ethernetCardName"));
                networkJsonArray.add((Object)newObject);
            }
            if (object.containsValue((Object)"VirtualDisk")) {
                newObject.put((Object)"storageType", object.get("storageType"));
                newObject.put((Object)"storageUuid", object.get("storageUuid"));
                newObject.put((Object)"devKey", object.get("devKey"));
                virtualDiskJsonArray.add((Object)newObject);
                newObject.put((Object)"unitNumber", object.get("unitNumber"));
                newObject.put((Object)"datastoreId", object.get("datastoreId"));
                newObject.put((Object)"storageFileName", object.get("storageFileName"));
                newObject.put((Object)"uuid", object.get("uuid"));
                newObject.put((Object)"sharing", object.get("sharing"));
            }
            if (!object.containsKey((Object)"contentDataStoreUuid")) continue;
            newObject.put((Object)"contentDataStoreUuid", object.get("contentDataStoreUuid"));
        }
    }

    public void generateVmBaseInfo(List<VsphereVirtualMachine> vms, ProtectObject po) {
        boolean vmNotExisted = true;
        for (VsphereVirtualMachine vm : vms) {
            if (!vm.getUuid().equals(po.getMoUuid())) continue;
            vmNotExisted = false;
            this.updateProtectObjectInfoByVmInfo(po, vm);
            break;
        }
        if (vmNotExisted) {
            logger.error((Object)("vm(" + po.getMoUuid() + ") is not existed."), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
    }

    private void updateProtectObjectInfoByVmInfo(ProtectObject po, VsphereVirtualMachine vm) {
        po.setMoUuid(vm.getUuid());
        po.setName(vm.getName());
        po.setPoType(10);
        po.setPoStatus(vm.getOsStatus().intValue());
        po.setProviderSN(vm.getTopMoUuid());
        this.updateProtectObjectPropsByVmInfo(po, vm);
    }

    private void updateProtectObjectPropsByVmInfo(ProtectObject po, VsphereVirtualMachine vm) {
        DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E status = DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E.getType((int)vm.getOsStatus());
        po.getProps().put("VMSTATUS", null == status ? DrmVsphereEnumDefine.VSPHERE_GUEST_STATUS_E.UNKNOWN.name() : status.name());
        po.getProps().put("HOSTUUID", vm.getHostUuid());
        po.getProps().put("VMPATH", vm.getVmPath());
        po.getProps().put("VMUUID", vm.getVmUuid());
        po.getProps().put("GUSTOS", vm.getGuestFullName());
        po.getProps().put("GUESTOSTYPE", vm.getGuestFamily());
        po.getProps().put("GUESTHOSTNAME", vm.getHostName());
        po.getProps().put("ISTEMPLATE", null == vm.getIsTemplate() ? "false" : vm.getIsTemplate().toString());
        VsVMObjectHelper.setVmConfigToProps(po.getProps(), vm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProtectObjectStorageInfo(List<ProtectObject> protectObjectList) {
        List results;
        if (VerifyUtil.isEmpty(protectObjectList)) {
            logger.warn((Object)"protectObjectList is empty.", 90160758787071L);
            return;
        }
        Object[] uuids = new String[protectObjectList.size()];
        String providerSn = this.getvCenterSnByVmUuid(protectObjectList.get(0).getMoUuid());
        if (VerifyUtil.isEmpty((String)providerSn)) {
            logger.warn((Object)"providerSn is empty.", 90160758787071L);
            return;
        }
        for (int i = 0; i < protectObjectList.size(); ++i) {
            if (VerifyUtil.isEmpty((String)protectObjectList.get(i).getMoUuid())) {
                logger.error((Object)"uuid is empty.", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            uuids[i] = protectObjectList.get(i).getMoUuid();
        }
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String hql = "select vds.id.vmUuid, vds from VmDataStore as vds where vds.id.vmUuid in (:uuid)";
            results = session.createQuery(hql).setParameterList("uuid", uuids).list();
        }
        catch (Exception e) {
            try {
                logger.error((Object)("query datastore error.vms is " + StringUtil.arrayToString((Object[])uuids) + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return;
        }
        DBOperationUtil.closeSession((Session)session);
        if (VerifyUtil.isEmpty((Collection)results)) {
            return;
        }
        this.dealQueryResult(protectObjectList, results, providerSn);
    }

    private String getvCenterSnByVmUuid(String tempVmUuid) {
        if (VerifyUtil.isEmpty((String)tempVmUuid)) {
            logger.warn((Object)"tempVmUuid is empty.", 90160758787071L);
            return "";
        }
        VsphereVirtualMachine tempVm = (VsphereVirtualMachine)CommonDAOLocator.getMoDao().getMo(VsphereVirtualMachine.class, "uuid", (Object)tempVmUuid);
        if (null == tempVm || VerifyUtil.isEmpty((String)tempVm.getTopMoUuid())) {
            logger.warn((Object)"tempVm is empty.", 90160758787071L);
            return "";
        }
        String providerSn = tempVm.getTopMoUuid();
        return providerSn;
    }

    private void dealQueryResult(List<ProtectObject> protectObjectList, List results, String vCenterSn) {
        String datastores;
        logger.debug((Object)("dealQueryResult start:vcenterSn=" + vCenterSn));
        HashMap queryResult = new HashMap();
        String hql = "from VsphereDataStoreDiskInfo where topMoUuid = ?";
        List dataStoreDisks = CommonDAOLocator.getMoDao().find(hql, new Object[]{vCenterSn});
        hql = "from VsphereDataStore where topMoUuid = ?";
        List dataStores = CommonDAOLocator.getMoDao().find(hql, new Object[]{vCenterSn});
        for (Object o : results) {
            if (null == o) continue;
            Object[] obj = (Object[])o;
            String vmuuid = (String)obj[0];
            VmDataStore dataStore = (VmDataStore)obj[1];
            if (VerifyUtil.isEmpty((String)vmuuid) || null == dataStore) continue;
            if (!queryResult.containsKey(vmuuid)) {
                ArrayList value = new ArrayList();
                queryResult.put(vmuuid, value);
            }
            ((List)queryResult.get(vmuuid)).add(dataStore);
        }
        boolean needCheckDs = false;
        HashSet<DataStoreInfo> dataStoreSet = new HashSet<DataStoreInfo>();
        if (!protectObjectList.iterator().hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = protectObjectList.iterator().next().getProtectGroup();
        if (null != pg && !VerifyUtil.isEmpty((String)(datastores = (String)pg.getProps().get("pgDsInfo")))) {
            JSONArray jsonArray = JSONArray.fromObject((Object)datastores);
            dataStoreSet = new HashSet(JSONArray.toCollection((JSONArray)jsonArray, DataStoreInfo.class));
            needCheckDs = true;
        }
        for (ProtectObject po : protectObjectList) {
            po.getUsedStorageResourceSet().clear();
            po.setProviderSN(vCenterSn);
            if (!queryResult.containsKey(po.getMoUuid())) continue;
            this.getUsedStorageResourceByDataStores(po, dataStoreSet, (List)queryResult.get(po.getMoUuid()), dataStores, dataStoreDisks, needCheckDs);
        }
    }

    public void getUsedStorageResourceByDataStores(ProtectObject po, Set<DataStoreInfo> dataStoreSet, List<VmDataStore> vmDatastores, List<VsphereDataStore> dataStores, List<VsphereDataStoreDiskInfo> dataStoreDisks, boolean needCheckDs) {
        logger.debug((Object)"getUsedStorageResourceByDataStores start");
        for (VmDataStore vmDatastore : vmDatastores) {
            if (needCheckDs && this.isRpOrSnapshotPg(po) && !this.isDsInPg(vmDatastore.getDataStoreUuid(), dataStoreSet) || needCheckDs && this.isSnapshot(this.getProtectTemplateTypeFromProtectGroup(po.getProtectGroup())) && !SUPPORT_VIRTUAL_DISK_TYPES.contains(vmDatastore.getType())) continue;
            ProtectObjectStorageInfo poStorage = this.generatePoStorageInfo(po, vmDatastore, dataStores, dataStoreDisks);
            po.addHostStorageResourceInfo(poStorage);
        }
    }

    private int getProtectTemplateTypeFromProtectGroup(ProtectGroup pg) {
        return pg.getTemplate().getType();
    }

    public void getComputeResourceInfo(List<VsphereVirtualMachine> vms, ProtectGroup protectGroup) {
        logger.debug((Object)"getComputeResourceInfo start");
        List resourcePools = CommonDAOLocator.getMoDao().find("from VsphereResourcePool", new Object[0]);
        JSONArray array = new JSONArray();
        HashSet<String> existedComputeResource = new HashSet<String>();
        block0: for (VsphereResourcePool resourcePool : resourcePools) {
            if (existedComputeResource.contains(resourcePool.getParentMo().getUuid())) continue;
            for (VsphereVirtualMachine vm : vms) {
                String rpUuidFromVM = vm.getResourcePoolUuid();
                if (!resourcePool.getUuid().equals(rpUuidFromVM)) continue;
                JSONObject obj = new JSONObject();
                ManagedObject computeResource = resourcePool.getParentMo();
                obj.put((Object)"computResourceUuid", (Object)computeResource.getUuid());
                obj.put((Object)"computeResourceName", (Object)computeResource.getName());
                HashMap<String, Object> hsProps = new HashMap<String, Object>();
                hsProps.put("computeResourceUuid", computeResource.getUuid());
                JSONArray hosts = this.getHostTopoByCptRes(hsProps);
                obj.put((Object)"hosts", (Object)hosts);
                array.add((Object)obj);
                existedComputeResource.add(computeResource.getUuid());
                continue block0;
            }
        }
        protectGroup.getProps().put("pg_topo", array.toString());
    }

    private JSONArray getHostTopoByCptRes(Map<String, Object> hsProps) {
        logger.debug((Object)"getHostTopoByCptRes start");
        List hostSystems = CommonDAOLocator.getMoDao().findMoBy(VsphereHostSystem.class, hsProps);
        JSONArray hosts = new JSONArray();
        for (VsphereHostSystem hostSystem : hostSystems) {
            JSONObject host = new JSONObject();
            host.put((Object)"uuid", (Object)hostSystem.getUuid());
            host.put((Object)"name", (Object)hostSystem.getName());
            host.put((Object)"status", (Object)hostSystem.getStatus());
            host.put((Object)"healthStatus", (Object)hostSystem.getHealthStatus());
            host.put((Object)"version", (Object)hostSystem.getVersion());
            hosts.add((Object)host);
        }
        return hosts;
    }

    private void setStorageInfo(ProtectObject po, String lunwwn, ProtectObjectStorageInfo poStorage) {
        logger.debug((Object)"setStorageInfo start");
        String[] lunValue = lunwwn.split(":/");
        poStorage.setLunWWN(lunwwn);
        if (lunValue.length == 2) {
            List list = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getFileSystemsByNFSShare(lunValue[0], "/" + lunValue[1], true);
            if (VerifyUtil.isEmpty((Collection)list)) {
                poStorage.setResourceProviderSN("UNKNOWN");
                poStorage.setResourceId(lunwwn);
            } else {
                NasFileSystem nfs = (NasFileSystem)list.iterator().next();
                poStorage.setResourceProviderSN(nfs.getDevSn());
                poStorage.setResourceId(nfs.getResourceId());
                poStorage.setResourceName(nfs.getName());
                poStorage.setVstoreId(nfs.getVstoreId());
                this.putVstoreHyperPairId(po.getProtectGroup(), nfs);
            }
            poStorage.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.NAS.getValue()));
        } else {
            List luns = CommonDAOLocator.getMoDao().getMoList(Lun.class, "wwn", (Object)lunwwn);
            if (VerifyUtil.isEmpty((Collection)luns)) {
                poStorage.setResourceProviderSN("UNKNOWN");
                poStorage.setResourceId(lunwwn);
            } else {
                Lun lunMo = (Lun)luns.get(0);
                poStorage.setResourceProviderSN(lunMo.getDevSn());
                poStorage.setResourceId(lunMo.getLunId());
                poStorage.setResourceName(lunMo.getName());
            }
            poStorage.setResourceType(Integer.valueOf(DrmEnumDefine.ResourceTypeE.LUN.getValue()));
        }
    }

    private void putVstoreHyperPairId(ProtectGroup protectGroup, NasFileSystem nasFileSystem) {
        String pairId;
        if (protectGroup != null && VerifyUtil.isEmpty((String)(pairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID"))) && !VerifyUtil.isEmpty((String)nasFileSystem.getVstoreId())) {
            try {
                VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstoreId(nasFileSystem.getDevSn(), nasFileSystem.getVstoreId());
                if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
                    logger.error((Object)("The vstoreHyperMetroPair does not exist." + nasFileSystem.getDevSn() + "  vstore:" + nasFileSystem.getVstoreId()));
                } else {
                    protectGroup.getProps().put("PROP_KEY_VSTORE_PAIR_ID", vstoreHyperMetroPair.getVstorePairId());
                    protectGroup.getProps().put("PROP_KEY_VSTORE_ID", vstoreHyperMetroPair.getLocalVstoreId());
                }
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("get vstoreHyperMetroPair error." + nasFileSystem.getDevSn() + "  vstore:" + nasFileSystem.getVstoreId()));
            }
        }
    }

    private boolean isDsInPg(String dsId, Set<DataStoreInfo> dataStoreSet) {
        logger.debug((Object)("isDsInPg start:dsId=" + dsId));
        for (DataStoreInfo ds : dataStoreSet) {
            if (!dsId.equals(ds.getDataStoreUuid())) continue;
            return true;
        }
        return false;
    }

    private ProtectObjectStorageInfo generatePoStorageInfo(ProtectObject po, VmDataStore vmDatastore, List<VsphereDataStore> dataStores, List<VsphereDataStoreDiskInfo> dataStoreDisks) {
        logger.debug((Object)"generatePoStorageInfo start");
        ProtectObjectStorageInfo poStorage = new ProtectObjectStorageInfo();
        poStorage.setId(UUIDGenerator.getUUID());
        String lunwwn = vmDatastore.getId().getLunWwn();
        this.setStorageInfo(po, lunwwn, poStorage);
        if (DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VMFS.getValue() == vmDatastore.getType()) {
            for (VsphereDataStoreDiskInfo disk : dataStoreDisks) {
                if (!disk.getStorageWwn().equals(vmDatastore.getId().getLunWwn())) continue;
                VsphereDataStore ds = (VsphereDataStore)disk.getParentMo();
                poStorage.setDeviceName(ds.getName());
                poStorage.setMountPoint(ds.getUrl());
                poStorage.setLabAddress(null == disk.getPartition() ? "" : disk.getPartition().toString());
                poStorage.setStorageType(Integer.valueOf(vmDatastore.getType()));
                break;
            }
        } else if (DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.PHYSICALRDM.getValue() == vmDatastore.getType() || DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.VIRTUALRDM.getValue() == vmDatastore.getType()) {
            poStorage.setDeviceName(vmDatastore.getRdmDiskName());
            for (VsphereDataStore ds : dataStores) {
                if (!ds.getUuid().equals(vmDatastore.getDataStoreUuid())) continue;
                poStorage.setMountPoint(ds.getUrl());
                break;
            }
            poStorage.setLabAddress("");
            poStorage.setStorageType(Integer.valueOf(vmDatastore.getType()));
            poStorage.setStorageShareType(vmDatastore.getRdmShareType());
        } else {
            poStorage.setDeviceName("UNKNOWN");
            poStorage.setMountPoint("/");
            poStorage.setLabAddress("");
            poStorage.setStorageType(Integer.valueOf(DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.UNSUPPORTED.getValue()));
        }
        return poStorage;
    }

    private boolean isRpOrSnapshotPg(ProtectObject po) {
        logger.debug((Object)"isRpOrSnapshotPg start");
        ProtectGroup pg = po.getProtectGroup();
        int type = pg.getTemplate().getType();
        if (this.isArrayReplication(type) || this.is3DCReplication(type) || this.isSnapshot(type)) {
            return true;
        }
        return PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(type);
    }

    private boolean isArrayReplication(int templateType) {
        logger.debug((Object)"isArrayReplication start");
        return replicationTypes.contains(templateType);
    }

    private boolean is3DCReplication(int templateType) {
        logger.debug((Object)"is3DCReplication start");
        return templateType == 4 || templateType == 3 || templateType == 6 || templateType == 5;
    }

    private boolean isSnapshot(int templateType) {
        logger.debug((Object)"isSnapshot start");
        return snapShotTypes.contains(templateType);
    }
}

