/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.tools;

import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.InitializingBean;

public final class VsphereResUtil
implements InitializingBean {
    private static final Log logger = LogFactory.getInstance(VsphereResUtil.class);
    private static final String DEFAULT_PROPERTIES = "conf.properties";
    private static VsphereResUtil instance;
    private Properties props = new Properties();

    public static synchronized VsphereResUtil getInstance() {
        if (null == instance) {
            instance = new VsphereResUtil();
        }
        return instance;
    }

    public String getValue(String key) {
        return this.getValue(key, null);
    }

    public String getValue(String key, String defaultValue) {
        String value = defaultValue;
        if (this.props != null) {
            value = this.props.getProperty(key, defaultValue);
        }
        return value;
    }

    public int getIntValue(String key, int defaultValue) {
        String value = this.getValue(key);
        if (NumberUtils.isDigits((String)value)) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public void afterPropertiesSet() {
        this.props = this.readProperties(DEFAULT_PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties readProperties(String propFile) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = AdapterUtils.getStreamResourceFromJar(VsphereResUtil.class, (String)propFile);
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (Exception e) {
            logger.error((Object)("read default.properties fail." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        finally {
            this.closeInputStream(inputStream);
        }
        return properties;
    }

    private void closeInputStream(InputStream inputStream) {
        try {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Closing input stream failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }
}

