/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.connection;

import com.huawei.ism.drm.kube.connection.KubeClientLoader;
import com.huawei.ism.drm.kube.util.KubeExceptionUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.client.Handlers;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.huawei.xuanwu.v1.BackupInstance;
import io.huawei.xuanwu.v1.BackupLocation;
import io.huawei.xuanwu.v1.Cluster;
import io.huawei.xuanwu.v1.Hook;
import io.huawei.xuanwu.v1.ProtectionPlan;
import io.huawei.xuanwu.v1.RecoveryPlan;
import io.huawei.xuanwu.v1.ResourceDetail;
import io.huawei.xuanwu.v1.ResourceSet;
import io.huawei.xuanwu.v1.RestoreJob;
import io.huawei.xuanwu.v1.SchedulePolicy;
import io.huawei.xuanwu.v1.StorageBackendClaim;
import io.huawei.xuanwu.v1.StorageBackendContent;
import io.huawei.xuanwu.v1.VolumeSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class KubeConnection {
    private static final Log LOG = LogFactory.getInstance(KubeConnection.class);
    private final KubernetesClient client;

    public KubeConnection(String devSn) {
        this.client = KubeClientLoader.getKubernetesClient(devSn);
    }

    public KubeConnection(KubernetesClient client) {
        this.client = client;
    }

    public <T extends HasMetadata> List<T> getList(Class<T> clazz) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return ((KubernetesResourceList)crdClient.list()).getItems();
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Get kube resource list error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public <T extends HasMetadata> List<T> getList(Class<T> clazz, String namespace) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return ((KubernetesResourceList)((NonNamespaceOperation)crdClient.inNamespace(namespace)).list()).getItems();
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Get kube resource list error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public <T extends HasMetadata> Optional<T> get(Class<T> clazz, String name) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return Optional.ofNullable(((Resource)crdClient.withName(name)).get());
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Get specific kube resource error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public <T extends HasMetadata> List<T> getByField(Class<T> clazz, String fieldName, String fieldValue) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return ((KubernetesResourceList)((FilterWatchListDeletable)crdClient.withField(fieldName, fieldValue)).list()).getItems();
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Get kube resource list by specific field error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public <T extends HasMetadata> List<T> getListByLabelKey(Class<T> clazz, String labelKey) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return ((KubernetesResourceList)((FilterWatchListDeletable)crdClient.withLabel(labelKey)).list()).getItems();
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Get kube resource list by resource label key error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public <T extends HasMetadata> List<T> getListByLabelAndWithoutLabelKey(Class<T> clazz, String labelKey, String withoutLabelKey) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return ((KubernetesResourceList)((FilterWatchListDeletable)((FilterWatchListDeletable)crdClient.withLabel(labelKey)).withoutLabel(withoutLabelKey)).list()).getItems();
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Get kube resource list by resource label key error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public <T extends HasMetadata> Optional<T> getOneByLabelKey(Class<T> clazz, String labelKey) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            List items = ((KubernetesResourceList)((FilterWatchListDeletable)crdClient.withLabel(labelKey)).list()).getItems();
            return VerifyUtil.isEmpty((Collection)items) ? Optional.empty() : Optional.of(items.get(0));
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Get kube resource with resource label key error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public <T extends HasMetadata> Optional<T> get(Class<T> clazz, String namespace, String name) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return Optional.ofNullable(((Resource)((NonNamespaceOperation)crdClient.inNamespace(namespace)).withName(name)).get());
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Get specific kube resource error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public <T extends HasMetadata> T create(Class<T> clazz, T request) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return (T)((HasMetadata)crdClient.create(request));
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Create kube resource error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public final <T extends HasMetadata> void delete(Class<T> clazz, T request) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            crdClient.delete((Object[])new HasMetadata[]{request});
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Delete kube resource error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public final <T extends HasMetadata> T createOrReplace(Class<T> clazz, T kubeResource) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return (T)((HasMetadata)crdClient.createOrReplace((Object[])new HasMetadata[]{kubeResource}));
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Modify(create or replace) kube resource error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public final <T extends HasMetadata> T createOrReplace(Class<T> clazz, String namespace, T kubeResource) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return (T)((HasMetadata)((NonNamespaceOperation)crdClient.inNamespace(namespace)).createOrReplace((Object[])new HasMetadata[]{kubeResource}));
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Modify(create or replace) kube resource error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public final <T extends HasMetadata> T edit(Class<T> clazz, Consumer<T> function) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return (T)((HasMetadata)crdClient.edit(item -> {
                function.accept(item);
                return item;
            }));
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Edit kube resource error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public final <T extends HasMetadata> T edit(Class<T> clazz, String resourceName, Consumer<T> function) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return (T)((HasMetadata)((Resource)crdClient.withName(resourceName)).edit(resource -> {
                function.accept(resource);
                return resource;
            }));
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Edit kube resource error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    public final <T extends HasMetadata> T edit(Class<T> clazz, String namespace, String resourceName, Consumer<T> function) {
        try {
            MixedOperation crdClient = this.client.resources(clazz);
            return (T)((HasMetadata)((Resource)((NonNamespaceOperation)crdClient.inNamespace(namespace)).withName(resourceName)).edit(resource -> {
                function.accept(resource);
                return resource;
            }));
        }
        catch (KubernetesClientException e) {
            LOG.error((Object)("Edit kube resource error, resource kind: " + clazz.getSimpleName()), (Throwable)e);
            throw KubeExceptionUtil.checkAndConvert(e);
        }
    }

    static {
        LOG.info((Object)"Start register cdr handler.");
        Thread.currentThread().setContextClassLoader(KubeConnection.class.getClassLoader());
        Handlers.register(ResourceSet.class, null);
        Handlers.register(Hook.class, null);
        Handlers.register(StorageBackendClaim.class, null);
        Handlers.register(StorageBackendContent.class, null);
        Handlers.register(BackupLocation.class, null);
        Handlers.register(SchedulePolicy.class, null);
        Handlers.register(BackupInstance.class, null);
        Handlers.register(ResourceDetail.class, null);
        Handlers.register(ProtectionPlan.class, null);
        Handlers.register(PersistentVolume.class, null);
        Handlers.register(ConfigMap.class, null);
        Handlers.register(Cluster.class, null);
        Handlers.register(RestoreJob.class, null);
        Handlers.register(RecoveryPlan.class, null);
        Handlers.register(PersistentVolumeClaim.class, null);
        Handlers.register(StorageClass.class, null);
        Handlers.register(DaemonSet.class, null);
        Handlers.register(VolumeSet.class, null);
        LOG.info((Object)"Success register cdr handler.");
    }
}

