/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.protection.replica.builder.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class ClusterRollBackTask
implements IRollbackItem {
    private static final Log LOGGER = LogFactory.getInstance(ClusterRollBackTask.class);
    private final String kubeSn;
    private final String name;

    public ClusterRollBackTask(String kubeSn, String name) {
        this.kubeSn = kubeSn;
        this.name = name;
    }

    public boolean execute() {
        if (VerifyUtil.isEmpty((String)this.kubeSn) || VerifyUtil.isEmpty((String)this.name)) {
            LOGGER.error((Object)"Rollback cluster failed. Param invalid.");
            return false;
        }
        LOGGER.warn((Object)"Rollback cdr cluster %s", new Object[]{this.name});
        IKubeHandler iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        boolean isClusterDelete = false;
        int maxTime = 10;
        for (int retryTime = 0; retryTime < maxTime && !isClusterDelete; ++retryTime) {
            long millis = 5000L;
            CommUtil.pauseThread((long)millis);
            isClusterDelete = iKubeHandler.deleteCluster(this.kubeSn, this.name);
        }
        return isClusterDelete;
    }
}

