/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.Kubernetes;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class KubeUtil {
    private static final Log LOGGER = LogFactory.getInstance(KubeUtil.class);

    public static Kubernetes getKubernetes(String sn) {
        List kubeList;
        VerifyUtil.checkStrs((String[])new String[]{sn});
        Session session = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Kubernetes.class);
            criteria.add((Criterion)Restrictions.eq((String)"dbId", (Object)sn));
            kubeList = criteria.list();
        }
        catch (DataAccessException e) {
            try {
                LOGGER.error((Object)"Failed to query kubernetes by sn:%s", new Object[]{sn});
                throw new LegoCheckedException(201L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return (Kubernetes)kubeList.stream().findAny().orElseThrow(() -> new LegoCheckedException(201L));
    }

    public static void buildServerReplica(ProtectGroup protectGroup) {
        KubeUtil.checkParam(protectGroup);
        ProtectGroupReplica replica = new ProtectGroupReplica();
        replica.setId(UUIDGenerator.getUUID());
        replica.setName("REMOTEREPLICA-" + protectGroup.getName());
        replica.setPg(protectGroup);
        replica.setStatus(DrmEnumDefine.ReplicaStatus.ACTIVE_STATUS.getValue());
        replica.setProtectLocation(DrmEnumDefine.ProtectLocation.A_B.getValue());
        replica.setType(13);
        Schedule schedule = (Schedule)protectGroup.getTemplate().getSchedules().iterator().next();
        replica.setRecoverySite(schedule.getTargetSiteId());
        replica.setProductArray(schedule.getSourceSn());
        replica.setRecoveryArray(schedule.getTargetSn());
        protectGroup.getReplicaList().add(replica);
        String sourceIp = KubeUtil.getKubernetes(schedule.getSourceSn()).getIpAddress();
        String targetIp = KubeUtil.getKubernetes(schedule.getTargetSn()).getIpAddress();
        protectGroup.getProps().put("sourceKubeClusterIp", sourceIp);
        protectGroup.getProps().put("targetKubeClusterIp", targetIp);
    }

    public static void checkParam(ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Collection)protectGroup.getPolist()) || VerifyUtil.isEmpty((Collection)protectGroup.getTemplate().getSchedules())) {
            LOGGER.error((Object)"Invalid pg param.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkProtectPlanStatusNormalOrPending(String devSn, String name) {
        block3: {
            Optional opt;
            long curTime;
            long startTime = System.currentTimeMillis();
            do {
                CommUtil.pauseThread((long)30000L);
                opt = ((IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class)).getProtectionPlan(devSn, name);
                if (!opt.isPresent()) {
                    LOGGER.error((Object)"Not find the protect protectPlan: %s", new Object[]{name});
                    throw new LegoCheckedException(2117645L);
                }
                if (((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.ERROR) {
                    LOGGER.error((Object)"The protect cdr PP is Error, can not create recovery.");
                    throw new LegoCheckedException(1073947751L, new String[]{name, ((KubeProtectionPlan)opt.get()).getStatus().getValue()});
                }
                if (((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.NORMAL || ((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.PENDING) break block3;
            } while ((curTime = System.currentTimeMillis()) - startTime < 360000L);
            LOGGER.error((Object)"Get PP status: %s by max wait time on %s.", new Object[]{((KubeProtectionPlan)opt.get()).getStatus().getValue(), devSn});
            throw new LegoCheckedException(1073947433L);
        }
        LOGGER.info((Object)"The protect cdr protection plan is normal or pending.");
    }

    public static void checkProtectPlanStatusNormalOrError(ProtectGroup protectGroup, String devSn, String name) {
        KubeProtectionPlan plan;
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        do {
            String planStatusInProtectGroup;
            CommUtil.pauseThread((long)10000L);
            Optional opt = kubeHandler.getProtectionPlan(devSn, name);
            if (!opt.isPresent()) {
                LOGGER.error((Object)"Not find the protect protectPlan: %s", new Object[]{name});
                throw new LegoCheckedException(2117645L);
            }
            plan = (KubeProtectionPlan)opt.get();
            String string = planStatusInProtectGroup = protectGroup.getPoProviderSN().equals(devSn) ? (String)protectGroup.getProps().get("sourceProtectionPlanStatus") : (String)protectGroup.getProps().get("targetProtectionPlanStatus");
            if (!plan.getStatus().getValue().equals(planStatusInProtectGroup)) {
                KubeUtil.updateProtectionPlanStatusInProps(protectGroup, devSn, plan);
            }
            if (plan.getStatus() != KubeEnumDefine.CDRProtectGroupStatus.ERROR) continue;
            LOGGER.error((Object)"The protect cdr PP on %s is Error, can not create recovery.", new Object[]{devSn});
            throw new LegoCheckedException(1073947751L, new String[]{name, ((KubeProtectionPlan)opt.get()).getStatus().getValue()});
        } while (plan.getStatus() != KubeEnumDefine.CDRProtectGroupStatus.NORMAL);
        LOGGER.info((Object)"The protect cdr PP is normal, can create recovery.");
    }

    public static void updateProtectionPlanStatusInProps(ProtectGroup protectGroup, String devSn, KubeProtectionPlan plan) {
        ProtectGroup curProtectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(protectGroup.getUuid());
        IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
        protectGroup.setProperty(protectGroup.getPoProviderSN().equals(devSn) ? "sourceProtectionPlanStatus" : "targetProtectionPlanStatus", (Object)plan.getStatus().getValue());
        curProtectGroup.setProperty(protectGroup.getPoProviderSN().equals(devSn) ? "sourceProtectionPlanStatus" : "targetProtectionPlanStatus", (Object)plan.getStatus().getValue());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)curProtectGroup);
    }

    public static String parseResourceVersion(String src) {
        if (VerifyUtil.isEmpty((String)src)) {
            return "";
        }
        if (src.contains("/")) {
            String[] arr = src.split("/");
            return arr[arr.length - 1];
        }
        return src;
    }
}

