/*
 * Decompiled with CFR 0.152.
 */
package io.huawei.xuanwu.v1;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.huawei.xuanwu.v1.protectionplanspec.LocalStorageBackend;
import io.huawei.xuanwu.v1.protectionplanspec.RemoteStorageBackend;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"enable", "enableVolumeConsistency", "localCluster", "localStorageBackend", "postHook", "preHook", "protectionPolicies", "rebuildSwitch", "remoteCluster", "remoteStorageBackend", "resourceSet", "retainTargetVolume", "retainVolumePair", "role", "volumeSet", "volumeSpeed"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ProtectionPlanSpec
implements KubernetesResource {
    @JsonProperty(value="enable")
    @JsonPropertyDescription(value="Enable defines whether this ProtectionPlan is enabled")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enable = true;
    @JsonProperty(value="enableVolumeConsistency")
    @JsonPropertyDescription(value="EnableVolumeConsistency defines whether this ProtectionPlan enable volume consistency group")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enableVolumeConsistency = true;
    @JsonProperty(value="localCluster")
    @JsonPropertyDescription(value="LocalCluster is the name of Cluster CR, which is local")
    @JsonSetter(nulls=Nulls.SKIP)
    private String localCluster;
    @JsonProperty(value="localStorageBackend")
    @JsonPropertyDescription(value="LocalStorageBackend includes information of the storage backend, which is local storage")
    @JsonSetter(nulls=Nulls.SKIP)
    private LocalStorageBackend localStorageBackend;
    @JsonProperty(value="postHook")
    @JsonPropertyDescription(value="PostHook is the name of Hook CR, which should be executed during creating or rebuilding")
    @JsonSetter(nulls=Nulls.SKIP)
    private String postHook;
    @JsonProperty(value="preHook")
    @JsonPropertyDescription(value="PreHook is the name of Hook CR, which should be executed during creating or rebuilding")
    @JsonSetter(nulls=Nulls.SKIP)
    private String preHook;
    @JsonProperty(value="protectionPolicies")
    @JsonPropertyDescription(value="ProtectionPolicies is a list of names of SchedulePolicy CRs. The ProtectionPolicyNames includes the time strategy for performing synchronization.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> protectionPolicies;
    @JsonProperty(value="rebuildSwitch")
    @JsonPropertyDescription(value="RebuildSwitch defines whether this ProtectionPlan starts rebuilding")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean rebuildSwitch = false;
    @JsonProperty(value="remoteCluster")
    @JsonPropertyDescription(value="RemoteCluster is the name of Cluster CR, which is remote")
    @JsonSetter(nulls=Nulls.SKIP)
    private String remoteCluster;
    @JsonProperty(value="remoteStorageBackend")
    @JsonPropertyDescription(value="RemoteStorageBackend includes information of the storage backend, which is remote storage")
    @JsonSetter(nulls=Nulls.SKIP)
    private RemoteStorageBackend remoteStorageBackend;
    @JsonProperty(value="resourceSet")
    @JsonPropertyDescription(value="ResourceSet is the name of resourceSet CR, resourceSet contains applications that need to be protected")
    @JsonSetter(nulls=Nulls.SKIP)
    private String resourceSet;
    @JsonProperty(value="retainTargetVolume")
    @JsonPropertyDescription(value="RetainTargetVolume defines whether this ProtectionPlan preserves target volume on deletion")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean retainTargetVolume = false;
    @JsonProperty(value="retainVolumePair")
    @JsonPropertyDescription(value="RetainVolumePair defines whether this ProtectionPlan preserves volume pair on deletion")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean retainVolumePair = false;
    @JsonProperty(value="role")
    @JsonPropertyDescription(value="ProtectionRole is the role of this ProtectionPlan")
    @JsonSetter(nulls=Nulls.SKIP)
    private Role role;
    @JsonProperty(value="volumeSet")
    @JsonPropertyDescription(value="VolumeSet is the name of volumeSet CR, volumeSet contains volumes that need to be protected")
    @JsonSetter(nulls=Nulls.SKIP)
    private String volumeSet;
    @JsonProperty(value="volumeSpeed")
    @JsonPropertyDescription(value="VolumeSpeed defines this ProtectionPlan's volume sync rate")
    @JsonSetter(nulls=Nulls.SKIP)
    private VolumeSpeed volumeSpeed;

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getEnableVolumeConsistency() {
        return this.enableVolumeConsistency;
    }

    public void setEnableVolumeConsistency(Boolean enableVolumeConsistency) {
        this.enableVolumeConsistency = enableVolumeConsistency;
    }

    public String getLocalCluster() {
        return this.localCluster;
    }

    public void setLocalCluster(String localCluster) {
        this.localCluster = localCluster;
    }

    public LocalStorageBackend getLocalStorageBackend() {
        return this.localStorageBackend;
    }

    public void setLocalStorageBackend(LocalStorageBackend localStorageBackend) {
        this.localStorageBackend = localStorageBackend;
    }

    public String getPostHook() {
        return this.postHook;
    }

    public void setPostHook(String postHook) {
        this.postHook = postHook;
    }

    public String getPreHook() {
        return this.preHook;
    }

    public void setPreHook(String preHook) {
        this.preHook = preHook;
    }

    public List<String> getProtectionPolicies() {
        return this.protectionPolicies;
    }

    public void setProtectionPolicies(List<String> protectionPolicies) {
        this.protectionPolicies = protectionPolicies;
    }

    public Boolean getRebuildSwitch() {
        return this.rebuildSwitch;
    }

    public void setRebuildSwitch(Boolean rebuildSwitch) {
        this.rebuildSwitch = rebuildSwitch;
    }

    public String getRemoteCluster() {
        return this.remoteCluster;
    }

    public void setRemoteCluster(String remoteCluster) {
        this.remoteCluster = remoteCluster;
    }

    public RemoteStorageBackend getRemoteStorageBackend() {
        return this.remoteStorageBackend;
    }

    public void setRemoteStorageBackend(RemoteStorageBackend remoteStorageBackend) {
        this.remoteStorageBackend = remoteStorageBackend;
    }

    public String getResourceSet() {
        return this.resourceSet;
    }

    public void setResourceSet(String resourceSet) {
        this.resourceSet = resourceSet;
    }

    public Boolean getRetainTargetVolume() {
        return this.retainTargetVolume;
    }

    public void setRetainTargetVolume(Boolean retainTargetVolume) {
        this.retainTargetVolume = retainTargetVolume;
    }

    public Boolean getRetainVolumePair() {
        return this.retainVolumePair;
    }

    public void setRetainVolumePair(Boolean retainVolumePair) {
        this.retainVolumePair = retainVolumePair;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public String getVolumeSet() {
        return this.volumeSet;
    }

    public void setVolumeSet(String volumeSet) {
        this.volumeSet = volumeSet;
    }

    public VolumeSpeed getVolumeSpeed() {
        return this.volumeSpeed;
    }

    public void setVolumeSpeed(VolumeSpeed volumeSpeed) {
        this.volumeSpeed = volumeSpeed;
    }

    public static enum VolumeSpeed {
        HIGHEST("Highest"),
        HIGH("High"),
        MEDIUM("Medium"),
        LOW("Low");

        String value;

        private VolumeSpeed(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public static VolumeSpeed getVolumeSpeed(String value) {
            return Arrays.stream(VolumeSpeed.values()).filter(item -> Objects.equals(item.value, value)).findAny().orElseThrow(() -> new LegoCheckedException(1073947393L));
        }
    }

    public static enum Role {
        PROTECTED("Protected"),
        RECOVERY("Recovery");

        String value;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

