# --*-- coding: utf-8 --*--

import utils.common.log as logger
from utils.DBAdapter.DBConnector import BaseOps
from utils.business.param_util import HandleParamCheck
from utils.business.param_util import ParamUtil
from utils.business.project_util import ProjectApi
from utils.common.code2Msg import code2Msg
from utils.common.exception import HCCIException

from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.lib.model import Auth
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.utils import check_value_null
from plugins.eReplication.common.os_api import API as OS_API


class ParamsCheck(object):
    """
    参数校验类，封装一些公共方法
    """

    # 相当于构造方法
    def __init__(self, project_id):
        self.project_id = project_id
        self.pod_id = BaseOps().get_pod_id_by_project_id(self.project_id)
        self.region_id = ProjectApi().get_regionlist_by_project_Id(
            self.project_id)[0]
        self.service_type = Component.REPLICATION
        self.db_opt = ParamUtil()
        self.nodes = Nodes(self.project_id, self.pod_id)
        self.need_check_data = self.db_opt.get_need_check_cloud_params(
            self.project_id, self.service_type)
        self.os_users_check_lst = list()
        self.check_result = HandleParamCheck()
        self.server_business_key = "eReplication_server_node_ssh_password"
        self.server_root_key = "eReplication_server_node_ssh_sudo_password"
        self.check_key_list = [self.server_business_key, self.server_root_key]
        self.server_ip1 = self.nodes.server_ip_01

    def basic_check(self):
        for key, value in self.need_check_data.items():
            if not check_value_null(value):
                continue
            logger.error(f"The value is None: {key}.")
            self.check_result.set_check_result(
                param_keys=[key], status=500, error_msg=code2Msg(665005))

    def _check_server_ip_login_and_user_expire(self, host=None):
        login_ok, check_ok = False, False
        host = host if host else self.server_ip1
        error_list = list()
        users = ["DRManager", "root"]
        ssh_pwd = self.need_check_data.get(self.server_business_key)
        sudo_pwd = self.need_check_data.get(self.server_root_key)
        auth_provider = Auth(host, "DRManager", ssh_pwd, "root", sudo_pwd)
        try:
            result = OS_API.check_os_password_expired_day(auth_provider, users)
        except Exception as err:
            logger.error(f"Check os user expire failed: {err}")
            self.check_result.set_check_result(
                self.check_key_list, status=500,
                error_msg=HCCIException(665009))
            return login_ok, check_ok
        login_ok = True
        for user, expire_day in result.items():
            if expire_day > 7:
                continue
            logger.error(
                f"The password of {user} on the {host} expires in "
                f"{expire_day} days. ")
            error_list.append({user: expire_day})
        if error_list:
            self.check_result.set_check_result(
                self.check_key_list, status=500, error_msg=HCCIException(
                    675021, error_list))
        else:
            check_ok = True
        return login_ok, check_ok

    def check_all_server_ip_login_and_user_expire(self):
        login1, check1 = self._check_server_ip_login_and_user_expire()
        self.os_users_check_lst.append(check1)
        if not login1:
            logger.error(f'Login {self.server_ip1} failed.')
            return self.check_result
        all_ips = self.nodes.get_all_server_nodes(
            self.server_ip1, "DRManager",
            self.need_check_data.get(self.server_business_key),
            "root", self.need_check_data.get(self.server_root_key))
        if len(all_ips) not in [2, 4] or self.server_ip1 not in all_ips:
            logger.error(
                f"Query eReplication ip from {self.server_ip1} failed.")
            self.check_result.set_check_result(
                param_keys=self.check_key_list, status=500,
                error_msg=code2Msg(665006))
            return self.check_result
        all_ips.remove(self.server_ip1)
        if not all_ips:
            return self.check_result
        for host in all_ips:
            login2, check2 = self._check_server_ip_login_and_user_expire(host)
            self.os_users_check_lst.append(check2)
        if False not in self.os_users_check_lst:
            self.check_result.set_check_result(
                param_keys=self.check_key_list, status=200, error_msg="")
        if not self.check_result.check_list:
            self.check_result.set_check_result(
                param_keys=self.check_key_list, status=200, error_msg="")
        return self.check_result

    def params_check(self):
        logger.info("Start eReplication params_check task.")
        self.basic_check()
        if self.check_result.check_list:
            return self.check_result
        return self.check_all_server_ip_login_and_user_expire()
