# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result

logger.init("ConfigSDR")


class ConfigSDR(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        DR_API.set_sdr_sys_config(
            self.project_id, self.pod_id, Component.CSDR_L)
