# -*- coding:utf-8 -*-
import utils.common.log as logger

from plugins.eReplication.common.client.mo_client import API as MO_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.params import Params

logger.init("ConfigServiceMonitor")


class ConfigServiceMonitor(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        nodes = Nodes(self.project_id, self.pod_id)
        params = Params(self.project_id, self.pod_id)
        auth_provider = MO_API.auth_provider(
            params.dmk_float_ip, params.dmk_port,
            params.dmk_deploy_user, params.dmk_user_new_pwd)
        MO_API(self.project_id, self.pod_id).deploy_ic_agent(nodes.hosts, nodes.ssh_user, auth_provider)
