# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import hashlib

import utils.common.log as logger
from utils.business.param_util import CheckResult
from utils.common.exception import HCCIException
from utils.common.software_package_util import find_software_package_by_name

from plugins.CSBS.common.util import get_dpa_plugin_config

logger.init("KarborProxy PluginCheck")

check_item = {
    "dap_plugin_check": {"name_cn": "DPA插件检查", "name_en": "Check dpa plugin.",
                         "error_code": '645065'}
}


def dpa_oracle_plugin_check():
    check_results = []
    logger.info("Check plugin start.")
    config_file = get_dpa_plugin_config()
    for key, value in config_file.config.items('dpa_plugin'):
        pkg_path, pkg_name = find_software_package_by_name(key)
        logger.info(f'Checking file {key}')
        with open(f"{pkg_path}/{pkg_name}", 'rb') as f:
            sha256obj = hashlib.sha256()
            sha256obj.update(f.read())
            hash_value = sha256obj.hexdigest()
        if hash_value != value:
            result = CheckResult(
                itemname_ch=check_item.get('dap_plugin_check', dict()).get('name_cn'),
                itemname_en=check_item.get('dap_plugin_check', dict()).get('name_en'),
                status="failure",
                error_msg_cn=HCCIException(
                    check_item.get('dap_plugin_check', dict()).get('error_code'),
                    str(HCCIException(645066, pkg_name))))
            check_results.append(result)
    if not check_results:
        check_result = CheckResult(itemname_ch=check_item.get('dap_plugin_check', dict()).get('name_cn'),
                                   itemname_en=check_item.get('dap_plugin_check', dict()).get('name_en'),
                                   status="success")
        check_results.append(check_result)
    return check_results
