#!/usr/bin/env python
# -*- coding: utf-8 -*-
import json

import utils.common.log as logger
from utils.business.project_util import ProjectApi
from utils.constant.business_constant import CMDBConstant

CSBS_VBS_INDEX_NAME = "CSBS-VBS"
INSTALLED_CSBS_SERVER = "InstalledCSBSServer"
INSTALLED_CSBS_PROXY = "InstalledCSBSProxy"


class CustomizeCondition:
    def __init__(self, project_id, cmdb_ins):
        self.project_id = project_id
        self.cmdb_ins = cmdb_ins
        self.project_api = ProjectApi()

    def execute(self):
        cur_region_id = self.project_api.get_regionlist_by_project_Id(self.project_id)[0]
        # 添加场景值
        csbs_vbs_scene_info = {
            INSTALLED_CSBS_SERVER: 0,
            INSTALLED_CSBS_PROXY: 0
        }
        csbs_vbs_cmdb_info = self._get_csbs_vbs_cmdb_info(self.cmdb_ins, cur_region_id)
        logger.info(f"The CSBS-VBS service information obtained from the CMDB is {csbs_vbs_cmdb_info}.")
        if not csbs_vbs_cmdb_info:
            raise Exception("Failed to get CSBS-VBS service state.")
        csbs_vbs_scene_info[INSTALLED_CSBS_SERVER] = 1
        for extend_info in csbs_vbs_cmdb_info.get(CMDBConstant.EXTENDS_INFO, []):
            if extend_info.get(CMDBConstant.EXTENDS_INFO_KEY) == "InstalledCSBS-VBS-Proxy":
                csbs_vbs_scene_info[INSTALLED_CSBS_PROXY] = 1 if extend_info.get(CMDBConstant.EXTENDS_INFO_VALUE) else 0
        logger.info(f"The {CSBS_VBS_INDEX_NAME} service scenario is {str(csbs_vbs_scene_info)}.")
        return json.dumps(csbs_vbs_scene_info)

    @staticmethod
    def _get_csbs_vbs_cmdb_info(cmdb_ins, cur_region_id):
        """获取cmdb中CSBS-VBS服务注册信息

        :param cmdb_ins: 接入cmdb的实例
        :param cur_region_id: 当前升级region_id
        :return:
        """
        cmdb_info = None
        if not cmdb_ins:
            raise Exception("The incoming param is not an instance of accessing the CMDB.")
        cmdb_data = cmdb_ins.get_region_infos(cur_region_id)
        service_info = cmdb_data.get(CMDBConstant.SERVICE_LAYER, [])
        if not service_info:
            return cmdb_info
        for unit in service_info:
            if unit.get(CMDBConstant.INDEXNAME) == CSBS_VBS_INDEX_NAME:
                cmdb_info = unit
                break

        return cmdb_info
