import utils.common.log as logger
from utils.common.check_result import CheckResult
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation

logger.init("KarborProxy")


class ProxyPreCheckCipherType(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(ProxyPreCheckCipherType, self).__init__(project_id, pod_id, regionid_list)
        self.karborproxy = KarborProxyOperation(project_id)
        self.ssh_client = SshClient()

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform installation & configuration.
        """
        cipher_type = self.karborproxy.get_proxy_cipher_type()
        logger.info(f"The current cipher types is {cipher_type.cur_cipher_type}.")
        try:
            karborproxy_cipher_type = self.karborproxy.get_karborproxy_cur_cipher_type()
        except Exception as err:
            logger.error(f"Execute error:{err}.")
            return Message(500, HCCIException(645046, str(err)))
        if karborproxy_cipher_type != cipher_type.cur_cipher_type:
            logger.error("The current cipher type does not match the cipher type of the karborproxy node.")
            return Message(500, HCCIException(645045, karborproxy_cipher_type, cipher_type.cur_cipher_type))
        logger.info("Checking the cipher type succeed.")
        return Message(200, check_results=[CheckResult(status="success")])
