import os

from utils.common import log as logger

from plugins.CSBS.common import node_installer
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.ssh_client import SshClient

logger.init("Karbor Installer")


class KarborInstaller(node_installer.ThreadInstaller):
    def __init__(self, project_id, pod_id):
        self.karbor_util = KarborUtil(project_id, pod_id)
        nod_list = self.karbor_util.get_karbor_node_list()
        logger.info(f"Get {len(nod_list)} karbor nodes.")
        super(KarborInstaller, self).__init__(nod_list)
        self.param_tool = ParamTool(project_id, pod_id)
        self.ssh_client = SshClient()

    def exec_cmds(self, node, cmds):
        karbor_client = self.ssh_client.get_ssh_client(node)
        sed_cmd_list = [
            "sed -i s/'PermitRootLogin no'/'PermitRootLogin yes'/g "
            "/etc/ssh/sshd_config",
            "sed -i s/'ChallengeResponseAuthentication yes'"
            "/'ChallengeResponseAuthentication no'/g /etc/ssh/sshd_config",
            "sed -i /^UsePrivilegeSeparation.*/d /etc/ssh/sshd_config",
            "sed -i /^PasswordAuthentication.*/d /etc/ssh/sshd_config",
            "sed -i /^AllowUsers.*/d /etc/ssh/sshd_config"]
        sed_cmds = ";".join(sed_cmd_list)
        logger.info("Start change sshd config.")
        self.ssh_client.ssh_exec_command_return(karbor_client, sed_cmds)
        restart_cmds = "service sshd restart"
        logger.info("Restart sshd service.")
        self.ssh_client.ssh_exec_command_return(karbor_client, restart_cmds)
        work_dir = self.karbor_util.get_installer_workdir()
        self.upload_sysini(node)
        cd_cmd = f"cd {work_dir}/CSBS/install_scripts"
        self.ssh_client.ssh_exec_command_return(karbor_client, cd_cmd)
        result = self.ssh_client.ssh_exec_command_return(karbor_client, cmds)
        self.ssh_client.ssh_close(karbor_client)
        if not self.ssh_client.is_ssh_cmd_executed(result):
            logger.error(f"Exec cmds failed. result is: {result}")
            return False
        logger.info("Exec cmds success.")
        return True

    def install_thread(self, node):
        config = os.path.basename(self.param_tool.get_installer_config())
        cmds = "bash install_karbor.sh install '%s'" % config
        logger.info("Start exec install cmds.")
        self.install_result[node.node_ip] = self.exec_cmds(node, cmds)

    def check_thread(self, node):
        cmds = "bash install_karbor.sh check"
        logger.info("Start exec check cmds.")
        self.check_result[node.node_ip] = self.exec_cmds(node, cmds)

    def rollback_thread(self, node):
        cmds = "bash install_karbor.sh rollback"
        logger.info("Start exec rollback cmds.")
        self.rollback_result[node.node_ip] = self.exec_cmds(node, cmds)

    def upload_sysini(self, karbor_node):
        logger.info("Start upload config file.")
        work_dir = self.karbor_util.get_installer_workdir()
        sysini_path = self.param_tool.get_installer_config()
        if os.path.exists(sysini_path):
            self.ssh_client.put(karbor_node.node_ip, "root", karbor_node.root_pwd, sysini_path, work_dir)
