import utils.common.log as logger
from utils.business.param_util import ParamUtil
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karbor.cbs_installer import cbs_karborazbackup

logger.init("KarborAZ")


class KarborAZ(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(KarborAZ, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.params = ParamUtil()

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info('Start Configuring Karbor Az Backup')
        try:
            if not cbs_karborazbackup.KarborAZBackup(project_id, pod_id).install():
                return Message(500, HCCIException("640049"))
        except Exception as err:
            logger.error(f"Execute error:{err}")
            return Message(500, HCCIException("640049"))
        logger.info('Succeed Configuring Karbor Az Backup')
        logger.info('All finished')
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list=None):
        try:
            if not cbs_karborazbackup.KarborAZBackup(project_id, pod_id).rollback():
                return Message(500, HCCIException("640049"))
        except Exception as err:
            logger.error(f"Execute error:{err}")
            return Message(500, HCCIException("640049"))
        return Message(200)
