import utils.common.log as logger
from utils.common.ssh_util2 import Ssh

from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxyDPAInfo
from plugins.CSBS.scripts.deploy.karborproxy.config.project_set import project_preset
from plugins.CSBS.scripts.deploy.karborproxy.config.shell_cmd import ShellCmd
from plugins.CSBS.scripts.deploy.karborproxy.config.ssh_cmd import SShCmd

logger.init("KarborProxy Connection Karbor And DPA")


class ConfigAZtoKarbor(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ConfigAZtoKarbor, self).__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd()
        self.agent_proxy = AgentProxyDPAInfo(project_id, pod_id)
        self.karbor_info = KarborUtil(project_id, pod_id)
        self.ssh_obj = Ssh()

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self._config_zone_az_info_to_karbor()

    def _config_zone_az_info_to_karbor(self):
        if not self.agent_proxy.openstack_expansion_az:
            raise Exception(" The openstack_expansion_az parameter cannot be empty.")
        karbor_node = self.karbor_info.get_karbor_node_list()[0]
        new_az = self.agent_proxy.openstack_expansion_az
        if self.agent_proxy.is_csha:
            config_mode = ShellCmd.config_mode % 'csha'
            config_az_cmd = "source /opt/huawei/dj/inst/utils.sh;" \
                            "ha_zone=`get_res_mgr_backend | grep 'ha_zone'` ;" \
                            "b_az=`get_res_mgr_configs | grep business_zone  | " \
                            "awk -F '|' '{print $3}' | sed 's/ //g'`;" \
                            "hz_az=`get_res_mgr_configs | grep  'ha_zone'  | awk -F '|' '{print $3}' | sed 's/ //g' " \
                            "`;new_az=%s; if [ \"$hz_az\" == \"\" ] && [ \"$ha_zone\" != \"\" ];" \
                            " then  set_res_mgr_configs --ha_zone $new_az; %s" \
                            "elif  [ \"$hz_az\" != \"\" ] && [ \"$ha_zone\" != \"\" ]; " \
                            "then set_res_mgr_configs --ha_zone $hz_az,$new_az; %s" \
                            "else set_res_mgr_configs --business_zone $b_az,$new_az; fi " % \
                            (new_az, config_mode, config_mode)

        else:
            # 直接配置业务az
            config_az_cmd = "source /opt/huawei/dj/inst/utils.sh;" \
                            "az=`get_res_mgr_configs | grep business_zone  | awk -F '|' '{print $3}'" \
                            " | sed 's/ //g'`;new_az=%s;" \
                            "if [ \"$az\" == \"\" ]; then set_res_mgr_configs --business_zone " \
                            "$new_az ; else set_res_mgr_configs --business_zone $az,$new_az;fi" % new_az

        self.ssh.ssh_cmd_to_karbor(karbor_node, config_az_cmd)
