import utils.common.log as logger
from utils.Logic.ServerOperate import ServerOperate
from utils.business.manageone_cmdb_util import ManageOneCmdbUtil
from utils.business.param_util import ParamUtil
from utils.business.vm_util import PublicServiceOM
from utils.common.fic_base import ToolClient
from utils.common.message import Message
from utils.common.message import RESULT_CODE
from utils.common.openstack_host import get_openstack_info_by_pod_id

from plugins.CSBS.common.constant import CSBS_SERVICE_NAME
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class UpdateKarbor2Info(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(UpdateKarbor2Info, self).__init__(project_id, pod_id, regionid_list)
        self.old_karbor2_name = "Service-CSBS2"
        self.old_karbor3_name = "Service-CSBS3"
        self.new_karbor2_name = "Service-CSBSdr"
        self.om_util = PublicServiceOM()
        self.cmdb_util = ManageOneCmdbUtil(self.project_id, self.pod_id)
        self.param_util = ParamUtil()
        self.region_id = self.param_util.get_param_value(
            self.pod_id, "public", "region_id", "region0_id")

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            return self._update_karbor_to_info()
        except Exception as err:
            logger.info(f"Failed to update karbor2 info, err_msg: {str(err)}.")
            return Message(RESULT_CODE['ERROR'], err, err)

    def _update_karbor_to_info(self):
        self._update_server_name()
        self._update_deploy_node_info()
        return Message(RESULT_CODE['SUCCESS'])

    def _update_deploy_node_info(self):
        logger.info("Start to update deploy node info.")
        node_infos = self.cmdb_util.get_deploy_node_info(self.region_id,
                                                         CSBS_SERVICE_NAME)
        update_node_info = []
        for node_info in node_infos:
            if node_info.get("name") == self.old_karbor3_name:
                continue
            if node_info.get("name") == self.old_karbor2_name:
                node_info["name"] = self.new_karbor2_name
                logger.info("The karbor2 node information is updated "
                            f"to {node_info}.")
            update_node_info.append(node_info)
        self.cmdb_util.set_deploy_node_infos(self.region_id,
                                             update_node_info)
        logger.info("Succeed to update deploy node info.")

    def _update_server_name(self):
        logger.info("Start to update karbor2 server name.")
        server_name_dict = {}
        karbor2_server_id = self._get_server_id_by_server_name(
            self.old_karbor2_name)
        server_name_dict[karbor2_server_id] = self.new_karbor2_name

        if not server_name_dict:
            raise Exception("Failed to organize server name dict.")
        logger.info(f"The update server dict are :{server_name_dict}.")
        self.om_util.update_server_name(self.pod_id, server_name_dict)
        logger.info("Succeed to update karbor2 server name.")

    def _get_server_id_by_server_name(self, server_name):
        auth_provider = get_openstack_info_by_pod_id(self.pod_id)
        host_and_tool = (auth_provider, ToolClient.OPENSTACK_COMPUTE)
        vm_operate = ServerOperate()
        vm_dict = vm_operate.get_servers_by_name(
            server_name=server_name, host_and_tool=host_and_tool)
        for vm_info in vm_dict['servers']:
            if vm_info['name'] == server_name or vm_info['name'].startswith(server_name):
                return vm_info['id']
        raise Exception(f"Get vm id failed, dest vm name is {server_name}.")
