import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.karborproxy_params import ProxyDMKClient
from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation
from plugins.CSBS.common.step_base import UpgradeBaseSubJob

logger.init("KarborProxy")


class UpgradeKarborProxy(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(UpgradeKarborProxy, self).__init__(project_id, pod_id, regionid_list)
        self.proxy_dmk_client = ProxyDMKClient(self.project_id, self.pod_id, self.regionid_list)
        self.proxy_operation = KarborProxyOperation(self.project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Login dmk and call DMK to upgrade KarborProxy.")
        action = "[Upgrade] CSBS-VBS KarborProxy"

        karborproxy_pkg_version = self.proxy_operation.get_karborproxy_pkg_version()
        try:
            result = self.proxy_dmk_client.dmk_deploy_karborproxy(action, karborproxy_pkg_version)
        except Exception as err:
            logger.error(f"Failed to upgrade KarborProxy, reason:{str(err)}.")
            return Message(500, HCCIException(645050))
        if not result:
            logger.error("Failed to upgrade Karbor.")
            return Message(500, HCCIException(645050))
        logger.info("Upgrade KarborProxy successfully.")

        return Message(200)
