#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation
from plugins.CSBS.common.upgrade.upgrade_os import UpgradeOS
from plugins.CSBS.common.util import MSG_500, MSG_200
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxyVMINFO
from plugins.CSBS.scripts.upgrade.karbor.base import BaseSubJob

logger.init("KarborProxy UpgradeOS")


class UpgradeOSStep(BaseSubJob):
    def __init__(self, project_id=None, pod_id=None, regionid_list=None):
        super(UpgradeOSStep, self).__init__(project_id, pod_id, regionid_list)
        self.params_tools = KarborProxyOperation(project_id)
        self.node_list = self.params_tools.get_proxy_node_list()
        self.upgrade_util = UpgradeOS(self.project_id, self.pod_id, self.node_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info("Start to upgrade os.")
        if not self.upgrade_util.install():
            logger.error(f"Filed to upgrade os.")
            return Message(MSG_500, HCCIException("645062"))
        logger.info("Upgrade os success.")
        self.upgrade_util.upload_kvm(AgentProxyVMINFO.vm_image_name)
        return Message(MSG_200)
