import utils.common.log as logger
from utils.common.check_result import CheckResult
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation
from plugins.CSBS.common.upgrade.params import ParamsTools

logger.init("KarborProxy")


class ProxyPreCheckOS(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(ProxyPreCheckOS, self).__init__(project_id, pod_id, regionid_list)
        self.karborproxy = KarborProxyOperation(project_id)
        self.param_tool = ParamsTools(project_id)
        self.ssh_client = SshClient()

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform installation & configuration.
        """

        try:
            result = self.karborproxy.check_karborproxy_os_version()
        except Exception as err:
            logger.error(f"Execute error:{err}.")
            return Message(500, HCCIException(645044, str(err)))
        if not result:
            return Message(500, HCCIException(645036))
        logger.info("Succeed to check the KarborProxy")
        return Message(200, check_results=[CheckResult(status="success")])
