from plugins.CSBS.common import node_installer
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.ssh_client import SshClient


class KarborOS(node_installer.ThreadInstaller):
    def __init__(self, project_id, pod_id):
        self.karbor_util = KarborUtil(project_id, pod_id)
        nod_list = self.karbor_util.get_karbor_node_list()
        super(KarborOS, self).__init__(nod_list)

    def exec_cmds(self, node, cmds):
        karbor_client = SshClient()
        ssh_client = karbor_client.get_ssh_client(node)
        work_dir = self.karbor_util.get_installer_workdir()
        cd_cmd = f"cd {work_dir}/CSBS/install_scripts"
        karbor_client.ssh_exec_command_return(ssh_client, cd_cmd)
        result = karbor_client.ssh_exec_command_return(ssh_client, cmds)
        karbor_client.ssh_close(ssh_client)
        return karbor_client.is_ssh_cmd_executed(result)

    def install_thread(self, node):
        cmds = "bash os_config.sh install"
        self.install_result[node.node_ip] = self.exec_cmds(node, cmds)

    def check_thread(self, node):
        cmds = "bash os_config.sh check"
        self.check_result[node.node_ip] = self.exec_cmds(node, cmds)

    def rollback_thread(self, node):
        cmds = "bash os_config.sh rollback"
        self.rollback_result[node.node_ip] = self.exec_cmds(node, cmds)
