import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.constant import RegisterToMOInfo
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.register_silvan import RegisterSilvan
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class AppBackupRegisterSilvan(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(AppBackupRegisterSilvan, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.csbs_service = "csbs"
        self.dbs_id = "dbs"
        self.fsbs_id = "fsbs"
        self.param_tool = ParamTool(self.project_id, self.pod_id)
        self.register_silvan = RegisterSilvan()
        self.region_id = self.param_tool.get_region_id()
        self.console_domain_name = \
            self.param_tool.get_console_domain_name()
        self.register_info = RegisterToMOInfo(
            self.region_id, self.console_domain_name)

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            return self._apply_link_and_register_info()
        except Exception as err:
            logger.error(str(err))
            return Message(500, HCCIException("640016", str(err)))

    def _apply_link_and_register_info(self):
        # dbs apply links
        result3_1 = self.register_silvan.register_links_info(
            self.pod_id, "apply_url_dbs", self.dbs_id, "detail", self.register_info.dbs_apply_link, "product",
            region_id=self.region_id)
        if not result3_1:
            logger.error(f"Register {self.dbs_id} apply link failed.")
            return Message(500, HCCIException("640019"))

        # fsbs apply links
        result3_2 = self.register_silvan.register_links_info(
            self.pod_id, "apply_url_fsbs", self.fsbs_id, "detail", self.register_info.fsbs_apply_link, "product",
            region_id=self.region_id)
        if not result3_2:
            logger.error(f"Register {self.fsbs_id} apply link failed.")
            return Message(500, HCCIException("640019"))

        # Register dbs product info.
        result4_1 = self.register_silvan.register_product_info(
            self.pod_id, self.region_id, self.dbs_id,
            self.register_info.dbs_product_info)
        if not result4_1:
            logger.error(f"Register {self.dbs_id} product info failed.")
            return Message(500, HCCIException("640020"))
        # Register fbs product info.
        result4_2 = self.register_silvan.register_product_info(
            self.pod_id, self.region_id, self.fsbs_id,
            self.register_info.fsbs_product_info)
        if not result4_2:
            logger.error(f"Register {self.fsbs_id} product info failed.")
            return Message(500, HCCIException("640020"))

        # Register application backup quota indicators.
        result5 = self.register_silvan.register_quota_indicators(
            self.pod_id, self.csbs_service,
            self.register_info.app_backup_quota_indicators)
        if not result5:
            logger.error("Register application backup quota indicator info failed.")
            return Message(500, HCCIException("640088"))

        # Register application backup meter metrics.
        result6 = self.register_silvan.register_meter_metrics(
            self.pod_id, self.register_info.app_backup_metric_info)
        if not result6:
            logger.error("Register application backup metric info failed.")
            return Message(500, HCCIException("640089"))

        return Message(200)
