import utils.common.log as logger
from utils.business.sdr_util import SDRApi
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.constant import RegisterSDRData
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import ParamTool
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("RegisterSDR")


class RegisterSDR(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(RegisterSDR, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.sdr = SDRApi(project_id)
        self.region_id = \
            ParamTool(self.project_id, self.pod_id).get_region_id()
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.register_sdr_data = RegisterSDRData(
            self.region_id, self.karbor_util.get_karbor_float_ip())

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            result = self._register_sdr()
        except Exception as err:
            logger.error("Failed to register SDR, err_msg:" + str(err))
            return Message(500, HCCIException("640001", str(err)))
        if not result:
            return Message(500, "Failed to turn on meter switch.")
        logger.info("Register SDR all finished.")
        return Message(200)

    def _register_sdr(self):
        logger.info("Start to register SDR.")
        self.sdr.reg_plugin(self.register_sdr_data.csbs_data)
        self.sdr.reg_plugin(self.register_sdr_data.vbs_data)
        logger.info("Succeed to register SDR.")

        result = self.karbor_util.change_meter_switch(tar_status="on")
        return result
