import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.dmk_tool import DmkTool
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")
RETRY = 3


class ResetDmkFirstLogin(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ResetDmkFirstLogin, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.dmk_tool = DmkTool(self.project_id, self.pod_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        logger.info('Start to reset dmk first login.')
        try:
            self.dmk_tool.reset_dmk_first_login()
        except HCCIException as err1:
            logger.error(f"Reset dmk first login failed, err_msg:{str(err1)}.")
            return Message(500, err1)
        except Exception as err2:
            logger.error(f"Execute error:{str(err2)}.")
            return Message(500, HCCIException(640007, str(err2)))

        logger.info('Succeed to reset dmk first login.')
        return Message(200)
