import time

import utils.common.log as logger

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.modification.region_con_ha.karborproxy.config.agent_proxy_param import AgentProxyVMINFO
from plugins.CSBS.scripts.modification.region_con_ha.karborproxy.config.project_set import project_preset
from plugins.CSBS.scripts.modification.region_con_ha.karborproxy.config.shell_cmd import ShellCmd
from plugins.CSBS.scripts.modification.region_con_ha.karborproxy.config.ssh_cmd import SShCmd


class KarborProxyConfigHA(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        logger.init("KarborProxyConfigHA")
        super().__init__(project_id, pod_id, regionid_list)
        self.ssh = SShCmd()
        self.agent_proxy = AgentProxyVMINFO(project_id, pod_id)

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self._config_ha_to_karborproxy()
        self._restart_omm_ha_karborproxy()
        self._check_omm_ha_status_karborproxy()

    def _config_ha_to_karborproxy(self):
        logger.info("Deployment kaborproxy ha start.")
        api_info = self.agent_proxy.get_arb_api_info()[0]
        cmd = ShellCmd.config_ha % api_info[0:3]
        self.ssh.ssh_exe_config_ha_cmd(self.agent_proxy, cmd, api_info[-1])
        logger.info("Deployment kaborproxy ha success.")

    def _restart_omm_ha_karborproxy(self):
        logger.info("Deployment kaborproxy omm-ha restart.")
        restart_omm_cmd = 'omm-haControl -A RESTART'
        self.ssh.ssh_cmds_to_all_proxys(self.agent_proxy, restart_omm_cmd)
        time.sleep(60)

    def _check_omm_ha_status_karborproxy(self):
        logger.info("Deployment kaborproxy omm-ha check status start.")
        self.config_ha_retry()

    def config_ha_retry(self):
        retry_count = 0
        while retry_count < 10:
            try:
                self.check_omm_ha_status()
                break
            except Exception as err:
                logger.error("ssh connect failed.%s" % err)
                retry_count = retry_count + 1
                if retry_count == 10:
                    raise Exception('Failed to configure the OMM HA.') from err
                time.sleep(60)

    def check_omm_ha_status(self):
        query_ha_status_cmd = 'omm-haControl -CS CompontState;' \
                              ' echo check omm_ha status $?'
        for obj in self.agent_proxy.get_proxy_node_list():
            ha_success_status = ['0', '2', '3']
            self.ssh.ssh_cmds(obj, query_ha_status_cmd, ha_success_status)
