#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger
from utils.business.vm_util import PublicServiceOM
from utils.common.message import Message

from plugins.CSBS.common.constant import KARBOR_PROXY_IMAGE_NAME
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation
from plugins.CSBS.common.upgrade.upgrade_os import UpgradeOS

logger.init("KarborProxy")


class DelOSUpgradeFiles(UpgradeBaseSubJob):
    def __init__(self, project_id=None, pod_id=None, regionid_list=None):
        super(DelOSUpgradeFiles, self).__init__(project_id, pod_id, regionid_list)
        self.ssh_client = SshClient()
        self.params_tools = KarborProxyOperation(project_id)
        self.node_list = self.params_tools.get_proxy_node_list()
        self.upgrade_os_util = UpgradeOS(project_id, pod_id, node_list=[])
        self.vm_util = PublicServiceOM()

    def execute(self, project_id, pod_id, regionid_list=None):
        # 删除备份的kvm
        self.vm_util.delete_image(pod_id=pod_id, image_name=f"{KARBOR_PROXY_IMAGE_NAME}_backup")
        for node in self.node_list:
            self.upgrade_os_util.clean_upgrade_file(node)
        return Message(200)
