#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger
from utils.business.vm_util import PublicServiceOM
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.constant import KARBOR_PROXY_IMAGE_NAME
from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation
from plugins.CSBS.common.upgrade.upgrade_os import UpgradeOS
from plugins.CSBS.common.util import MSG_500, MSG_200

logger.init("KarborProxy UpgradeOS")


class ProxyRollbackOS(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(ProxyRollbackOS, self).__init__(project_id, pod_id, regionid_list)
        node_list = KarborProxyOperation(project_id).get_proxy_node_list()
        self.upgrade_os_util = UpgradeOS(self.project_id, self.pod_id, node_list)
        self.vm_util = PublicServiceOM()

    def execute(self, project_id, pod_id, regionid_list=None):
        image_name = KARBOR_PROXY_IMAGE_NAME
        logger.info("Start to rollback os.")
        if not self.upgrade_os_util.rollback():
            logger.error(f"Filed to upgrade os.")
            return Message(MSG_500, HCCIException("645063"))
        logger.info("Rollback os success.")
        backup_image = self.vm_util.get_image_info_by_name_id(pod_id=pod_id,
                                                              image_name=f"{image_name}_backup")
        if backup_image:
            self.vm_util.delete_image(pod_id=pod_id, image_name=image_name)
            self.vm_util.update_image_attributes(pod_id, f"{image_name}_backup",
                                                 name=image_name)
        return Message(MSG_200)
