from datetime import datetime

import utils.common.log as logger

logger.init("CSBS")


def check_pwd_will_expired(ssh_client, os_client, os_account, will_expired_threshold=7):
    """检查用户密码将要过期的时间是否小于阈值时间

    注意：传入的os_clientt对象的权限要等于或者高于os_account
    :param ssh_client:
    :param will_expired_threshold:
    :param os_account:
    :param os_client:
    :return:小于阈值时间返回True，大于等于阈值时间返回False
    """
    pwd_expires_cmd = f"chage -l {os_account} | grep 'Password expires'| awk -F ': ' {{'print $2'}}"
    try:
        ret1 = ssh_client.ssh_exec_command_return(os_client, pwd_expires_cmd)
    except Exception as ex:
        err_msg = f"Failed to get {os_account} password expired time, error information: {str(ex)}."
        logger.error(err_msg)
        raise Exception(err_msg) from ex
    if not ssh_client.is_ssh_cmd_executed(ret1):
        err_msg = f"Failed to execute cmd to check {os_account} pwd expired time, cmd result: {str(ret1)}."
        logger.error(err_msg)
        raise Exception(err_msg)
    expire_time_str = ret1[0]
    if expire_time_str.lower() == 'never':
        return False
    elif "must be changed" in expire_time_str.lower():
        return True
    expire_time = datetime.strptime(expire_time_str, '%b %d, %Y')
    os_time_cmd = "date +%F"
    ret2 = ssh_client.ssh_exec_command_return(os_client, os_time_cmd)
    if not ssh_client.is_ssh_cmd_executed(ret1):
        logger.warning("Failed to execute cmd to obtain os time.")
        return False
    os_time = datetime.strptime(ret2[0].strip(), '%Y-%m-%d')
    days_expired = (expire_time - os_time).days
    if days_expired < will_expired_threshold:
        logger.info(f"The {os_account} password will expired in {str(days_expired)} days "
                    f"which less than {str(will_expired_threshold)} days.")
        return True
    return False
