# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.manageone_util import ManageOneUtil

from plugins.CSBS.common.util import auto_retry

logger.init("CSBS")


class RegisterSilvan(object):
    def __init__(self):
        self.mo_util = ManageOneUtil()

    @auto_retry(max_retry_times=5, delay_time=60)
    def register_endpoint(self, pod_id, region_id, service_name,
                          endpoint_info, _type="zh"):
        result = self.mo_util.register_endpoint_information(
            pod_id, region_id, endpoint_info)
        if result:
            logger.info(f"Register {service_name} {_type} endpoint successfully.")
            return True
        return False

    @auto_retry(max_retry_times=5, delay_time=60)
    def register_region_and_endpoint_association(self, pod_id, region_id,
                                                 service_name, float_ip,
                                                 port):
        result = self.mo_util.register_region_to_endpoint_information(
            pod_id, service_name, region_id, float_ip, port)
        if result:
            logger.info(f"Register {service_name} service of the association "
                        f"between region and endpoints successfully.")
            return True
        return False

    @auto_retry(max_retry_times=5, delay_time=60)
    def register_links_info(self, pod_id, link_key, link_content, icon_name,
                            href, _type, domain_type="SC", region_id=""):
        result = self.mo_util.register_links_information(
            pod_id, link_key, link_content, icon_name,
            href, _type, domainType=domain_type, region_id=region_id)
        if result:
            logger.info(f"Register {link_content} links successfully.")
            return True
        return False

    @auto_retry(max_retry_times=5, delay_time=60)
    def register_product_info(self, pod_id, region_id, service_name,
                              product_info):
        result = self.mo_util.register_product_information(
            pod_id, region_id, product_info)
        if result:
            logger.info(f"Register {service_name} product information successfully.")
            return True
        return False

    @auto_retry(max_retry_times=5, delay_time=60)
    def register_quota_indicators(self, pod_id, service_id, quota_info):
        result = self.mo_util.register_quota_indicators(
            pod_id, service_id, quota_info)
        if result:
            logger.info(f"Register {service_id} quota information successfully.")
            return True
        return False

    @auto_retry(max_retry_times=5, delay_time=60)
    def register_meter_metrics(self, pod_id, metric_info):
        result = self.mo_util.register_meter_metrics(pod_id, metric_info)
        if result:
            logger.info(f"Register metric information successfully.")
            return True
        return False

    @auto_retry(max_retry_times=5, delay_time=60)
    def register_product_action(self, pod_id, product_action):
        result = self.mo_util.register_product_action(pod_id, product_action)
        if result:
            logger.info(f"Register product action successfully.")
            return True
        return False
