#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from utils.business.param_util import HandleParamCheck
from utils.business.project_util import ProjectApi

from plugins.CSBS.common.upgrade.params_checker import ParamsChecker
from plugins.CSBS.common.upgrade.proxy_params_checker import ProxyParamsCheck

INSTALLED_CSBS_SERVER = "InstalledCSBSServer"
INSTALLED_CSBS_PROXY = "InstalledCSBSProxy"


def params_check(project_id):
    """interface function of plugin params checking

    error info returned:
        1. HCCIException(error_code, *arg, **kwargs),
           which can catch error from frame's functions
           supporting both Chinese and English.
        2. code2Msg(error_code, *arg, **kwargs),
           which can catch error from plugins' functions
           supporting both Chinese and English.
    :parma project_id:
    : return:
    """
    project_conditions = ProjectApi().get_project_conditions(project_id)
    check_result = HandleParamCheck()
    if project_conditions.get(INSTALLED_CSBS_SERVER):
        params_checker = ParamsChecker(project_id)
        # check karbor related params, including ip, password
        check_result = params_checker.check_karbor_login_ability(check_result)

    return check_result
