import os
import stat

FLAGS = os.O_WRONLY | os.O_TRUNC | os.O_CREAT
MODES = stat.S_IWUSR | stat.S_IRUSR


class OperationFile(object):

    def __init__(self):
        cur_path = os.path.dirname(os.path.realpath(__file__))
        self.agent_pkg_sign_file = os.path.join(cur_path, "agent_pkg_sign")
        self.assistant_pkg_sign_file = os.path.join(
            cur_path, "assistant_pkg.sha256")

    def add_sign(self, sign_list):
        with os.fdopen(os.open(self.agent_pkg_sign_file, FLAGS, MODES),
                       'w') as fout:
            for value in sign_list:
                fout.write(str(value) + '\n')

    def add_assistant_pkg_sign(self, sign_list):

        with os.fdopen(os.open(self.assistant_pkg_sign_file, FLAGS, MODES),
                       'w') as fout:
            for value in sign_list:
                fout.write(str(value) + '\n')
