import utils.common.log as logger
from utils.common.exception import HCCIException

from plugins.CSBS.common.step_base import DeployBaseSubJob
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxy
from plugins.CSBS.scripts.deploy.karborproxy.config.project_set import project_preset
from plugins.CSBS.scripts.deploy.karborproxy.config.shell_cmd import ShellCmd
from plugins.CSBS.scripts.deploy.karborproxy.config.ssh_cmd import SShCmd

logger.init("KarborProxy")


class AlgorithmSwitching(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(AlgorithmSwitching, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.agentproxy = AgentProxy(project_id, pod_id)
        self.ssh = SShCmd()

    @project_preset
    def execute(self, project_id, pod_id, regionid_list=None):
        self._change_cipher_type()
        self._change_os_cipher()

    def _change_cipher_type(self):
        logger.info("Ssh to karborproxy node and change cipher type.")
        cmd = ShellCmd.algorithm_switchover % self.agentproxy.cipher_type
        node_list = self.agentproxy.get_proxy_node_list()
        if not node_list:
            logger.error("Get proxy node list failed!")
            raise HCCIException("640001", "Get proxy node list failed!")
        node = node_list[0]
        self.ssh.ssh_cmds_to_proxy(node, cmd)

    def _change_os_cipher(self):
        logger.info("Ssh to karborproxy node and change os cipher.")
        cmd = ShellCmd.change_os_cipher % self.agentproxy.cipher_type
        self.ssh.ssh_cmds_to_all_proxys(self.agentproxy, cmd)
