import time

import utils.common.log as logger
from utils.Logic.ServerOperate import ServerOperate
from utils.business.vm_util import PublicServiceOM
from utils.common.fic_base import ToolClient
from utils.common.message import Message
from utils.common.message import RESULT_CODE
from utils.common.openstack_host import get_openstack_info_by_pod_id

from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class MigrationVM(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(MigrationVM, self).__init__(project_id, pod_id, regionid_list)
        self.om_util = PublicServiceOM()

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform installation & configuration.
        :param project_id:
        :param pod_id:
        :return:Message object
        """
        try:
            return self._migrate_karbor_vm()
        except Exception as err:
            logger.info(f"Failed to migrate vm, err_msg: {str(err)}.")
            return Message(RESULT_CODE['ERROR'], err, err)

    def _migrate_karbor_vm(self):
        logger.info("Start migration vm process.")
        migrate_vm_id_list = []
        server_id = self._get_server_id_by_server_name("Service-CSBS2")
        migrate_vm_id_list.append(server_id)
        logger.info(f"Migration vm id list: {migrate_vm_id_list}.")
        retry_times = 0
        migration_vm_flag = False
        while retry_times < 3:
            try:
                # 迁移karbor2虚拟机
                self.om_util.batch_migration_vm(self.pod_id, migrate_vm_id_list)
            except Exception as err:
                logger.warning(f"An error occurred while migrating the VM, err_msg:{str(err)}.")
                retry_times += 1
                time.sleep(60)
            else:
                migration_vm_flag = True
                break

        if not migration_vm_flag:
            raise Exception("Failed to migrate the VM.")

        logger.info("Migration vm process finished.")
        return Message(RESULT_CODE['SUCCESS'])

    def _get_server_id_by_server_name(self, server_name):
        auth_provider = get_openstack_info_by_pod_id(self.pod_id)
        host_and_tool = (auth_provider, ToolClient.OPENSTACK_COMPUTE)
        vm_operate = ServerOperate()
        vm_dict = vm_operate.get_servers_by_name(
            server_name=server_name, host_and_tool=host_and_tool)
        for vm_info in vm_dict['servers']:
            if vm_info['name'] == server_name or vm_info['name'].startswith(server_name):
                return vm_info['id']
        raise Exception(f"Get vm id failed, dest vm name is {server_name}.")
