import utils.common.log as logger
from utils.business.manageone_cmdb_util import ManageOneCmdbUtil
from utils.business.param_util import ParamUtil
from utils.common.exception import HCCIException
from utils.common.message import Message
from utils.common.message import RESULT_CODE

from plugins.CSBS.common.constant import CSBS_SERVICE_NAME
from plugins.CSBS.common.step_base import DeployBaseSubJob

logger.init("CSBS")


class KarborProxyUpdateCMDB(DeployBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(KarborProxyUpdateCMDB, self).__init__(project_id, pod_id, regionid_list)
        self.service_name = CSBS_SERVICE_NAME
        self.cmdb_util = ManageOneCmdbUtil(self.project_id, self.pod_id)
        self.param_util = ParamUtil()
        self.region_id = self.param_util.get_param_value(
            self.pod_id, "public", "region_id", "region0_id")

    def execute(self, project_id, pod_id, regionid_list=None):
        try:
            self._update_ha_modifyed_to_cmdb()
        except Exception as err:
            logger.error(f"Failed to update 'RegionConHAModified' scene "
                         f"value to cmdb, err_msg:{err}.")
            return Message(RESULT_CODE['ERROR'],
                           HCCIException(640001, str(err)))
        logger.info("Succeed to update 'RegionConHAModified' scene "
                    "value to cmdb.")
        return Message(RESULT_CODE['SUCCESS'])

    def _update_ha_modifyed_to_cmdb(self):
        # 从CMDB获取注册信息
        cmdb_service_name = f"{self.service_name}_{self.region_id}"
        logger.info(f"Start to obtain cloud service info from CMDB, "
                    f"cmdb service name:{cmdb_service_name}.")
        service_info_list = self.cmdb_util.get_cloud_service_info(
            region_code=self.region_id,
            index_name=self.service_name,
            name=cmdb_service_name)
        if not service_info_list:
            raise Exception("Failed to obtain cloud service info from CMDB.")
        logger.info(f"The cloud service information obtained "
                    f"from the CMDB is: {service_info_list}.")

        # 组织注册数据
        cloud_service_info = dict()
        for service_info in service_info_list:
            if not service_info.get("name") == cmdb_service_name:
                continue
            cloud_service_info["indexName"] = service_info.get("indexName")
            cloud_service_info["version"] = service_info.get("version")
            cloud_service_info["name"] = service_info.get("name")
            extend_info_list = []
            for extend_info in service_info.get("extendInfos"):
                extend_info_list.append(extend_info)
            extend_info_list.append(
                {"key": "CSBS-VBS-ProxyRegionConHAModified",
                 "value": "True"})
            cloud_service_info["extendInfos"] = extend_info_list

        if not cloud_service_info:
            raise Exception("Failed to construct CMDB data.")

        # 注册CMDB
        logger.info(f"Start to register cloud service info to CMDB, "
                    f"cloud service info is: {cloud_service_info}.")
        self.cmdb_util.set_cloud_service_info(
            region_code=self.region_id,
            cloud_service_info=cloud_service_info)
