#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger
from utils.business.vm_util import PublicServiceOM
from utils.common.message import Message

from plugins.CSBS.common.constant import KARBOR_IMAGE_NAME
from plugins.CSBS.common.ssh_client import SshClient
from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.common.upgrade.upgrade_os import UpgradeOS
from plugins.CSBS.scripts.upgrade.karbor.base import BaseSubJob

logger.init("CSBS-VBS")


class DelOSUpgradeFiles(BaseSubJob):
    def __init__(self, project_id=None, pod_id=None, regionid_list=None):
        super(DelOSUpgradeFiles, self).__init__(project_id, pod_id, regionid_list)
        self.ssh_client = SshClient()
        self.karbor_operation = KarborOperation(project_id)
        self.upgrade_os_util = UpgradeOS(project_id, pod_id, node_list=[])
        self.vm_util = PublicServiceOM()

    def execute(self, project_id, pod_id, regionid_list=None):
        # 删除备份的kvm
        try:
            self.vm_util.delete_image(pod_id=pod_id, image_name=f"{KARBOR_IMAGE_NAME}_backup")
        except Exception as err:
            logger.warning(f"Delete old image failed. {err}")
        for node in self.karbor_operation.karbor_node_list:
            self.upgrade_os_util.clean_upgrade_file(node)
        return Message(200)
