#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.upgrade.karborproxy import KarborProxyOperation
from plugins.CSBS.common.upgrade.upgrade_os import UpgradeOS
from plugins.CSBS.common.util import MSG_500, MSG_200, auto_retry
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxyVMINFO
from plugins.CSBS.scripts.upgrade.karbor.base import BaseSubJob
from plugins.CSBS.scripts.upgrade.karborproxy.sub_job_proxy_service_check import PreCheckProxyState

logger.init("KarborProxy UpgradeOS")


class UpgradeOSStep(BaseSubJob):
    def __init__(self, project_id=None, pod_id=None, regionid_list=None):
        super(UpgradeOSStep, self).__init__(project_id, pod_id, regionid_list)
        self.params_tools = KarborProxyOperation(project_id)
        self.node_list = self.params_tools.get_proxy_node_list()
        self.upgrade_util = UpgradeOS(self.project_id, self.pod_id, self.node_list)
        self.proxy_pre_check = PreCheckProxyState(project_id=project_id, pod_id=pod_id, regionid_list=regionid_list)

    def execute(self, project_id, pod_id, regionid_list=None):
        result = self._check_proxy_service()
        if not result:
            return Message(MSG_500, HCCIException("645067"))
        logger.info("Start to upgrade os.")
        if not self.upgrade_util.install():
            logger.error(f"Filed to upgrade os.")
            return Message(MSG_500, HCCIException("645062"))
        logger.info("Upgrade os success.")
        try:
            self.upgrade_util.upload_kvm(AgentProxyVMINFO.vm_image_name)
        except Exception as err:
            logger.warning(f"Upload image failed. {err}")
        return Message(MSG_200)

    @auto_retry()
    def _check_proxy_service(self):
        logger.info("Start to check service state.")
        result = self.proxy_pre_check.execute(self.project_id, self.pod_id, self.regionid_list)
        if result.status_code != 200:
            logger.error('Check karbor proxy service failed.')
            raise HCCIException(645067)
        for check_result in result.check_results:
            logger.info(f"Check {check_result.itemname_en} component.")
            if check_result.status != 'success':
                logger.info(f"Check {check_result.itemname_en} component failed.")
                raise HCCIException(645067)
        logger.info("Check all service component success.")
        return True

