#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="gaussdbRestore"
HOST_IP=$(get_info manage_ip)


function stop_gaussdb_service()
{    
    #stop gaussdb server but don't stop container
    heartBeat STOP omm-ha >/dev/null 2>&1
    kill_process /opt/huawei/dj/bin/ha/module/hamon/bin/ha_monitor
    kill_process /opt/huawei/dj/bin/ha/module/hacom/bin/ha.bin
    echo_info "kill omm-ha process success on node ${HOST_IP}."
    bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh stop unknown >>/dev/null 2>&1
    ECHO_RETURN $? "stop gaussdb failed on node ${HOST_IP}."
    echo_info "stop gaussdb success on node ${HOST_IP}."
    sleep 2
}

function start_gaussdb_data()
{
    #Start gaussdb standby
    bash /opt/huawei/dj/tools/gaussdb/sync_monitor.sh reset_status
    ECHO_RETURN $? "reset gaussdb status failed on node ${HOST_IP}."
    bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh repair force_repair >>/dev/null 2>&1
    ECHO_RETURN $? "repair gaussdb standby failed on node ${HOST_IP}."
    echo_info "repair gaussdb standby success on node ${HOST_IP}."
    sleep 2
    bash /opt/huawei/dj/tools/gaussdb/gaussdb_helper.sh deactive unknown >>/dev/null 2>&1
    ECHO_RETURN $? "deactive gaussdb standby failed on node ${HOST_IP}."
    echo_info "deactive gaussdb standby success on node ${HOST_IP}."
    sleep 2
}

if [[ "$1" = "stopgaussdb" ]];then
    stop_gaussdb_service
elif [[ "$1" = "startgaussdb" ]];then
    start_gaussdb_data
else
    ECHO_RETURN 1 "$1 not support on node ${HOST_IP}."
fi