# - encoding:utf-8 -
import configparser
import os
import stat

import netifaces


def get_local_ip(parser):
    try:
        ip_version = parser.get("SYSTEM", "ip_version")
        net = netifaces.AF_INET6 if ip_version == "ipv6" else netifaces.AF_INET
        interface = netifaces.gateways()['default'][net][1]
        return netifaces.ifaddresses(interface)[net][0]['addr']
    except Exception:
        return None


def configuration_conversion():
    config_file = "/opt/huawei/dj/cfg/sys.ini"
    exec_flag = "configuration_conversion_flag"
    exec_flag_value = "1"
    parser = configparser.RawConfigParser()
    parser.read(config_file)
    if exec_flag in parser.options("FEATURE") and parser.get("FEATURE", exec_flag) == exec_flag_value:
        return True

    manage_ip = get_local_ip(parser)
    parser.set("SYSTEM", "manage_ip", manage_ip)

    section = parser.sections()
    section.remove("SYSTEM")
    section.remove("FEATURE")
    manage_ip_list = section[:]
    if parser.get("SYSTEM", "profile") == "private_recover" and len(manage_ip_list) > 2:
        manage_ip_list.pop()
    parser.set("SYSTEM", "manage_ip_list", ",".join(manage_ip_list))

    hostname = parser.get(manage_ip, "hostname")
    parser.set("SYSTEM", "hostname", hostname)

    hostname_list = list()
    for ip in manage_ip_list:
        hostname_list.append(parser.get(ip, "hostname"))
    parser.set("SYSTEM", "hostname_list", ",".join(hostname_list))

    for ip in section:
        parser.remove_section(ip)
    parser.set("FEATURE", exec_flag, exec_flag_value)

    flags = os.O_WRONLY | os.O_CREAT | os.O_TRUNC
    modes = stat.S_IWUSR | stat.S_IRUSR
    with os.fdopen(os.open(config_file, flags, modes), 'w') as fd:
        parser.write(fd)
    return True


if __name__ == "__main__":
    configuration_conversion()
