#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi

source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="cli-client"
sys_ini="/opt/huawei/dj/cfg/sys.ini"

echo "${1}" | xargs | grep -E "^https://[-a-zA-Z0-9./:]+$">/dev/null
CHECK_RESULT $? "Incorrect endpoint. Please try again."

read -rs svc_account_pwd
echo "${svc_account_pwd}" | xargs | grep -E "^[A-F0-9#]+$">/dev/null
CHECK_RESULT $? "Incorrect account. Please try again."

kms_endpoint="kms_endpoint=$1"
svc_account_name="svc_account_name=op_svc_csbs"
svc_account_password="svc_account_password=${svc_account_pwd}"

line=$(grep -n '\[SYSTEM\]' "${sys_ini}" | cut -d: -f1)
ret=$(grep kms_endpoint "${sys_ini}")
if [[ -z "${ret}" ]];then
    sed -i "${line}a${kms_endpoint}" "${sys_ini}"
else
    sed -i "s#kms_endpoint.*#${kms_endpoint}#" "${sys_ini}"
fi

ret=$(grep svc_account_name "${sys_ini}")
if [[ -z "${ret}"  ]];then
    sed -i "${line}a${svc_account_name}" "${sys_ini}"
else
    sed -i "s#svc_account_name.*#${svc_account_name}#" "${sys_ini}"
fi

ret=$(grep svc_account_password "${sys_ini}")
if [[ -z "${ret}" ]];then
    sed -i "${line}a${svc_account_password}" "${sys_ini}"
else
    sed -i "s/svc_account_password.*/${svc_account_password}/" "${sys_ini}"
fi
log_info "Set kms config successfully."