#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function upgrade_cli_client()
{
    log_info "begin cli-client Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old cli-client"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new cli-client"
    log_info "Finish cli-client Upgrade action."
}

log_info "begin cli-client Upgrade."
upgrade_cli_client
touch "${CURRENT_PATH}/cli-client_upgrade_finish"
log_info "Upgrade cli-client success."